<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use Carbon\Carbon;

class BranchAttendanceEXC implements FromCollection , WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
        foreach($this->data as $val) {
            ++$i;
            $itemArray = [
                    'S.NO'             => $i,
                    'Date'             => Carbon::parse($val->date)->format('d-M-Y'),
                    'Branch Name'      => $val->Branch->branch_name,
                    'Branch Code'      => $val->Branch->branch_code,
                    'In Time'          => date("h:i:s A", strtotime($val->in_time)),
                    'In Message'       => $val->message_morning,
                    'Out Time'         => isset($val->out_time) ? date("h:i:s A", strtotime($val->out_time)) : '',
                    'Out Message'      => $val->message_night,
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }
    public function headings(): array
    {

        return ['S.NO', 'Date', 'Branch Name', 'Branch Code', 'In Time', 'In Message','Out Time','Out Message'];
    }
}
