<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Carbon\Carbon;

class EnrollmentClientMissingSerialExport implements  FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;

        foreach($this->data as $item) {
            $miss= "";
            foreach(json_decode($item->missing_serial_no) as $key){
                $miss .= $key.',';
            }
            $itemArray = [
                    'S.NO'                           => ++$i,
                    'Missing serial number'               => $miss,
                    'Operator Code'                         => $item->operator_code,
                    'Operator Name'                  => $item->Operator->Operator_Name,
                    'Branch Name'                    => $item->Operator->Operator_Code,
                    'Branch Code'                   => $item->Branch->branch_name,
                    'District'             => $item->Operator->District,
                    'State'             => $item->Operator->State,
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }



    public function headings(): array
    {

        return ['S.NO', 'Missing serial number', 'Operator Code', 'Operator Name', 'Branch Name', 'Branch Code', 'District', 'State'];
    }
}
