<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Carbon\Carbon;

class OperatorAttendanceEXC implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
        foreach($this->data as $val) {
            ++$i;
            $itemArray = [
                    'S.NO'             => $i,
                    'Date'             => Carbon::parse($val->date)->format('d-M-Y'),
                    'Operator Name'      => $val->Operator->Operator_Name,
                    'Operator Code'      => $val->Operator->Operator_Code,
                    'In Time'          => date("h:i:s A", strtotime($val->in_time)),
                    'In Message'       => $val->message_morning,
                    'Out Time'         => isset($val->out_time) ? date("h:i:s A", strtotime($val->out_time)) : '',
                    'Out Message'      => $val->message_night,
                ];

            $collection->push($itemArray);
        }
        return $collection;
    }
    public function headings(): array
    {

        return ['S.NO', 'Date', 'Operator Name', 'Operator Code', 'In Time', 'In Message','Out Time','Out Message'];
    }
}
