<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithDrawings;
use DB;

class PSPL implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;

        foreach($this->data as $item) {
            ++$i;
            // dd($item['c_date'],$item['Operator_Code']);
            $bankData = DB::table('bankuplods')->select('amount_credited')->where('Operator_Code',$item['Operator_Code'])->whereDate('date_of_transaction',date('d-m-Y', strtotime($item['c_date'])))->first();

            if(isset($bankData)){
                // dd($bankData);
                $total_pending = (($item['total_amount_collected_A']+$item['total_amount_collected_B'])-$bankData->amount_credited);
            }else{
                $total_pending = ($item['total_amount_collected_A']+$item['total_amount_collected_B']);
            }
            $itemArray = [
                'S.NO'                      => $i,
                'Branch Code'               => $item['branch_code'],
                'Date of Enrolment'         => date('d-m-Y', strtotime($item['c_date'])),
                'Station_ID'                => $item['Station_ID'],
                'Operator_ID'               => $item['Operator_Code'],
                'Operator Name'             => $item['Operator_Name'],
                'District'                  => $item['District'],
                'State'                     => $item['State'],
                'Pincode'                   => $item['pincode'],
                'Total No of Enrollment'    => $item['total_enrollment'],
                'Total No of update'        => $item['total_no_of_update'],
                'New Enrolments'            => $item['new_enrollments'],
                'Demographic Updates'       => $item['total_demographic_update'] ?? 0,
                'Mandatory Biometric Updates(5/15 years)' => $item['mandatory_bio_biometric_update'] ?? 0,
                'Biometric Updates'         => $item['biometric_update'] ?? 0,
                'Total Amount Collected Towards Demographic Updates.' => $item['total_amount_collected_A'] ?? 0,
                'Total Amount  Collected Towards Biometric Updates'   => $item['total_amount_collected_B'] ?? 0,
                'Pending Payment'                                     => $total_pending ?? 0
            ];

            $collection->push($itemArray);
        }
        return $collection;

    }



    public function headings(): array
    {

        return ['S.NO', 'Branch Code', 'Date of Enrolment', 'Station_ID', 'Operator_ID', 'Operator Name', 'District', 'State', 'Pincode', 'Total No of Enrollment', 'Total No of update', 'New Enrolments', 'Demographic Updates', 'Mandatory Biometric Updates(5/15 years)', 'Biometric Updates','Total Amount Collected Towards Demographic Updates.','Total Amount  Collected Towards Biometric Updates','Total Amount to be Collected'];
    }
}
