<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithDrawings;
use Carbon\Carbon;
use DB;

class SalaryExcel implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
        foreach($this->data as $item) {
            ++$i;
            $itemArray = [
                    'S.NO'                     => $i,
                    'Branch'                   => $item->branch->branch_name,
                    'District'                 => $item->operator->District,
                    'Operator ID'              => $item->operator->Operator_Code,
                    'Operator/Supervisor Name' => $item->operator->Operator_Name,
                    'Father Name'              => $item->Father_Name,
                    'Date Of Joining'          => Carbon::parse($item->created_at)->format('d-M-Y'),
                    'Salary Date'              => $item->salary_date,
                    'Total Present days in month'=> $item->total_present_in_month,
                    'Total Full Day'        => $item->total_fullday_count,
                    'Total Half Day'        => $item->total_halfday_count,
                    'Payout@11098'          => $item->payout,
                    'ESIC @.75%'            => $item->ESIC,
                    'PF @12%'               => $item->PF,
                    'Employer ESIC @ 3.25%' => $item->Employer_ESIC,
                    'Employer PF @ 13%'     => $item->Employer_PF,
                    'TOTAL'                 => $item->TOTAL,
                    'Net Salary'            => $item->Net_Salary,
                    'PF NO'                 => $item->PF_NO,
                    'ESI NO'                => $item->ESI_NO
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }
 

   
    public function headings(): array
    {

        return ['S.NO', 'Branch', 'District', 'Operator ID', 'Operator/Supervisor Name', 'Father Name', 'Date Of Joining', 'Salary Date', 'Total Present days in month','Total Full Day','Total Half Day','Payout@11098','ESIC @.75%','PF @12%','Employer ESIC @ 3.25%','Employer PF @ 13%','TOTAL','Net Salary','PF NO','ESI NO'];
    }
}