<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\Admin;
use App\Models\Branch;
use App\Models\ModelType;
use App\Models\ModelHasRole;
use Illuminate\Http\Request;
use App\Models\PermissionsBranch;
use App\Models\PermissionsOperator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;

class AdminRolePermissionsController extends Controller
{
    public function role()
    {
        $permission_groups = ModelType::where('parent_id', 0)->where('type','admin')->with(['SubModel'])->get();

        return view('admin.role.role', compact('permission_groups'));
    }
    public function list()
    {
        $role = Role::all();

        return view('admin.role.list', compact('role'));
    }

    public function roleCreate(Request $request)
    {
        if($request->name == null){
            $notification = array(
                'message' => 'Enter Role name ',
                'alert-type' => 'error'
            );
            return back()->with($notification);
        }

        $role = Role::where('name', $request->name)->first();
        if ($role) {
            $notification = array(
                'message' => 'Role name already create!',
                'alert-type' => 'error'
            );
            return back()->with($notification);
        }
        $roleSave = new Role();
        $roleSave->name = $request->name;
        $roleSave->guard_name = 'super Admin';
        $roleSave->save();
        $modelType = ModelType::where('parent_id', 0)->where('type','admin')->get();
        foreach ($modelType as $key => $model) {
            $parent = 'Parent_' . $model->id;
            $permissions = 'permissions_' . $model->id;
            if ($request->$parent) {
                foreach ($request->$parent as $key => $p) {
                    foreach ($request->$permissions as $keyp => $permissions) {
                        $ModelHasRole = new ModelHasRole();
                        $ModelHasRole->role_id = $roleSave->id;
                        $ModelHasRole->model_type = $model->id;
                        $ModelHasRole->model_id = $permissions;
                        $ModelHasRole->save();
                    }
                }
            }
        }

        $notification = array(
            'message' => 'Role Create successfully!',
            'alert-type' => 'success'
        );
        return redirect()->route('admin.role_has_permissions.view', [$roleSave->id])->with($notification);
    }

    public function roleUpdate(Request $request)
    {
       // dd($request->all());
        ModelHasRole::where([['role_id',$request->role_id]])->delete();

        $modelType = ModelType::where('parent_id', 0)->where('type','admin')->get();
        foreach ($modelType as $key => $model) {
            $parent = 'Parent_' . $model->id;
            $permissions = 'permissions_' . $model->id;
            if ($request->$parent) {
                foreach ($request->$parent as $key => $p) {
                    foreach ($request->$permissions as $keyp => $permissions) {
                        $ModelHasRole = new ModelHasRole();
                        $ModelHasRole->role_id = $request->role_id;
                        $ModelHasRole->model_type = $model->id;
                        $ModelHasRole->model_id = $permissions;
                        $ModelHasRole->save();
                    }
                }
            }
        }

        $notification = array(
            'message' => 'Role Update successfully!',
            'alert-type' => 'success'
        );
        return redirect()->route('admin.role_has_permissions.view', [$request->role_id])->with($notification);
    }

    //show all role

    public function listViewold($id)
    {
        $ModelHasRole = ModelHasRole::select('model_type',  'role_id')
            ->where('role_id', $id)
            ->groupBy('model_type', 'role_id') // Include all selected columns
            ->get();
        $role = Role::where('id', $id)->first();
        //    dd($ModelHasRole);
        return view('admin.role.index', compact('role', 'ModelHasRole'));
    }

    public function listView($id)
    {
        $permission_groups = ModelType::where('parent_id', 0)->where('type','admin')->with(['SubModel'])->get();
        $role = Role::where('id', $id)->first();
        //    dd($ModelHasRole);
        return view('admin.role.index', compact('role', 'permission_groups'));
    }



    public function AddUser(Request $request)
    {
        $roles = Role::all();
        $admins = Admin::all();
        return view('admin.role.add', compact('roles', 'admins'));
    }

    // public function editUser(Request $request,$id)
    // {
    //     $roles = Role::all();
    //     $admins = Admin::all();
    //     $admins = Admin::all();
    //     return view('admin.role.add', compact('roles','admins'));
    // }

    public function addUserStore(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'user_name'              => 'required',
            'role'                   => 'required',
            'contact_number'         => 'required',
            'address'                => 'required',
            'email'                  => 'required|email|unique:admins,email,' . $request->id,
            'password'               => 'required',
            'confirm_password'       => 'same:password',
        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withInput($request->input())
                ->withErrors($validator->errors());
        }

        $branchObj = new Admin();
        $branchObj->name = $request->user_name;
        $branchObj->role       = $request->role;
        $branchObj->email    = $request->email;
        $branchObj->phone_no    = $request->contact_number;
        $branchObj->address    = $request->address;
        $branchObj->password    = Hash::make($request->password);
        $branchObj->view_password = $request->password;
        $branchObj->save();
        return back()->with(['message' => 'User Added Successfully', 'alert-type' => 'success']);
    }
    public function addUserStoreUpdate(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'user_name'              => 'required',
            'role'                   => 'required',
            'contact_number'         => 'required',
            'address'                => 'required',
            'email'                  => 'required|email|unique:admins,email,' . $request->id,
            'password'               => 'nullable',
            'confirm_password'       => 'same:password',
        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withInput($request->input())
                ->withErrors($validator->errors());
        }

        $branchObj = Admin::where('id', $request->id)->first();
        $branchObj->name = $request->user_name;
        $branchObj->role       = $request->role;
        $branchObj->email    = $request->email;
        $branchObj->phone_no    = $request->contact_number;
        $branchObj->address    = $request->address;
        if ($request->password) {
            $branchObj->password    = Hash::make($request->password);
            $branchObj->view_password = $request->password;
        }

        $branchObj->save();
        return back()->with(['message' => 'User update Successfully', 'alert-type' => 'success']);
    }

    /// Branch Permissions

    public function BranchListView($id)
    {
        $permission_groups = ModelType::where('parent_id', 0)->where('type','branch')->with(['SubModel'])->get();
        $branch = Branch::where('branch_code', $id)->first();
        //    dd($branch);
        return view('admin.role.branch.index', compact('branch', 'permission_groups'));
    }

    public function PermissionsCreateBranch(Request $request)
    {
       // dd( $request->all());




        PermissionsBranch::where('branch_code',$request->branch_code)->delete();
        $modelType = ModelType::where([['parent_id', 0],['type','branch']])->get();
        foreach ($modelType as $key => $model) {
            $parent = 'Parent_' . $model->id;
            $permissions = 'permissions_' . $model->id;
            if ($request->$parent) {
                foreach ($request->$parent as $key => $p) {
                    foreach ($request->$permissions as $keyp => $permissions) {
                        $ModelHasRole = new PermissionsBranch();
                        $ModelHasRole->branch_code = $request->branch_code;
                        $ModelHasRole->model_type = $model->id;
                        $ModelHasRole->model_id = $permissions;
                        $ModelHasRole->save();
                    }
                }
            }
        }

        $notification = array(
            'message' => 'Branch permissions Create successfully!',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }
    //PermissionsCreateOperator
    public function PermissionsCreateOperator(Request $request)
    {
    //    dd( $request->all());




       PermissionsOperator::where('operator_code',$request->operator_code)->delete();
        $modelType = ModelType::where([['parent_id', 0],['type','operators']])->get();
        foreach ($modelType as $key => $model) {
            $parent = 'Parent_' . $model->id;
            $permissions = 'permissions_' . $model->id;
            if ($request->$parent) {
                foreach ($request->$parent as $key => $p) {
                    foreach ($request->$permissions as $keyp => $permissions) {
                        $ModelHasRole = new PermissionsOperator();
                        $ModelHasRole->operator_code = $request->operator_code;
                        $ModelHasRole->model_type = $model->id;
                        $ModelHasRole->model_id = $permissions;
                        $ModelHasRole->save();
                    }
                }
            }
        }

        $notification = array(
            'message' => 'operator permissions Create successfully!',
            'alert-type' => 'success'
        );
        return redirect()->back()->with($notification);
    }
}
