<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;
use App\Models\Admin;
use Illuminate\Support\Facades\{DB, Session};
class AdminBranchController extends Controller
{
    //

    public function Index(Request $request){
        if (Session::get('adminsession')) {
            $admin = Admin::where('id', Session::get('adminsession')->id)->first();
            
            if (DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 13]])->first() || DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 14]])->first() || $admin->role == 1) {
                // dd('jj');
                $assing = 1;
            } else {
                //  dd('jjll');
                return redirect()->route('admin.not.access')->with('error', 'This Model not Assing!');
            }
        }
        if($request->isMethod('post')){

            $validator = Validator::make($request->all(), [
                'branch_code'              => 'required|unique:branches,branch_code,' . $request->id,
                'branch_name'              => 'required',
                'state'                    => 'required',
                'district'                 => 'required',
                'branch_contact_person'    => 'required',
                'branch_contact_number'    => 'required',
                'email'                    => 'required|email|unique:branches,email,' . $request->id,
                'branch_address'           => 'required',
                'password'                 => 'required',
                'confirm_password'         => 'same:password',
            ]);
            
            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->withInput($request->input())
                    ->withErrors($validator->errors());
            }
            
            if($request->id){
                $inputArr = $request->except('_token');
                unset($inputArr['confirm_password']);
                $inputArr['password']      = Hash::make($request->password);
                $inputArr['view_password'] = $request->password;
                $inputArr['status'] = !empty($request->status)?1:0;
                Branch::where('id', $request->id)->update($inputArr);
                return redirect('admin/view-branch')->with(['message'=>'Branch Updated Successfully','alert-type'=>'success']);
            }else{

            $branchObj = new Branch();
            $branchObj->branch_code = $request->branch_code;
            $branchObj->branch_name = $request->branch_name;
            $branchObj->state       = $request->state;
            $branchObj->district    = $request->district;
            $branchObj->branch_contact_person    = $request->branch_contact_person;
            $branchObj->branch_contact_number    = $request->branch_contact_number;
            $branchObj->branch_address    = $request->branch_address;
            $branchObj->email       = $request->email;
            $branchObj->password    = Hash::make($request->password);
            $branchObj->view_password = $request->password;
            $branchObj->status      = !empty($request->status)?1:0;
            
             $res =  $branchObj->save();
             $genId = "B".sprintf("%03d", $branchObj->id);
             Branch::where('id',$branchObj->id)->update(['branch_id'=>$genId]);
            }
                return redirect('admin/view-branch')->with(['message'=>'Branch Added Successfully','alert-type'=>'success']);
        
            }

        $branchList = Branch::orderBy('id','DESC')->paginate(50);

        return view('admin.add-branch',compact('branchList'));
    }


    public function ViewBranch(){
        $branch = Branch::select('id','branch_name','branch_code')->orderBy('branch_name','ASC')->get();
        $branchList = Branch::orderBy('id','DESC')->paginate(50);
        return view('admin.view-branch',compact('branchList','branch'));
    }
    public function getUpdate($id){
        $singleData = Branch::findOrFail($id);
        return view('admin.add-branch', compact('singleData'));
    }
}
