<?php

namespace App\Http\Controllers\admin;

use \Crypt;
use App\Models\Branch;
use App\Models\Operator;
use App\Models\Registrar;
use App\Models\Attendance;
use App\Models\Bankupload;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\EnrollmentClient;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Excel;
use App\Exports\BranchAttendanceEXC;
use App\Exports\OperatorAttendanceEXC;

class AdminDashboardController extends Controller
{
    //
    public function Index(Request $req)
    {
        $operators = Operator::get();

        // $operatorInactive = Operator::where('status', '0')->count();
        //Top 5 Operators (Daily Enrolment Wise)
        $currrentDate = date('Y-m-d');
        $currentDatelast30day = date('Y-m-d', strtotime('-30 days'));
        // dd($currrentDate,date('Y-m-d', strtotime('-30 days')));
        $enrollmentListTopDailyWise = EnrollmentClient::join('operators', 'enrolment_clients.Operator_ID', '=', 'operators.Operator_Code')
            ->whereBetween('enrolment_clients.c_date', [$currentDatelast30day, $currrentDate])
            ->select(
                'operators.Operator_Name',
                DB::raw('COUNT(*) as number')
            )
            ->groupBy('enrolment_clients.Operator_ID', 'operators.Operator_Name')
            ->orderBy('number', 'DESC')
            ->limit(5)
            ->get()->toArray();


        // $pendingTopPaymentOperator = $results->sortByDesc('pending_amount')->take(5)->values();
        $branchList = DB::table('operators')
            ->select('operators.Station_Code', 'operators.Operator_Code', 'operators.Operator_Name', 'branches.branch_name', 'operators.EA_Code', 'branches.district')
            ->join('branches', 'operators.branch_id', '=', 'branches.branch_code');

        $branchLists = $branchList->get();



        $enrollmentList = [];
        foreach ($branchLists as $key => $val) {
            $enrollmentList[$key]['Operator_Code'] = $val->Operator_Code;
            $enrollmentList[$key]['Operator_name'] = $val->Operator_Name;
            $total_collect_amount = EnrollmentClient::where('Operator_ID', $val->Operator_Code)->sum('Total_amount_charged');
            $enrollmentList[$key]['total_collect_amount'] = $total_collect_amount;
            $enrollmentList[$key]['total_pending_amount']   = $total_collect_amount - Bankupload::where('Operator_Code', $val->Operator_Code)->sum('amount_credited');
        }
        usort($enrollmentList, function ($a, $b) {
            return $b['total_pending_amount'] - $a['total_pending_amount'];
        });

        // Get the top 5 entries with the highest 'total_pending_amount'
        $pendingTopPaymentOperator = array_slice($enrollmentList, 0, 5);
        $pendingResults = EnrollmentClient::selectRaw('
        COALESCE(e.branch_code, b.branch_code) AS branch_code,
        COALESCE(SUM(e.Total_amount_charged), 0) AS total_amount_charged,
        COALESCE(SUM(b.amount_credited), 0) AS total_amount_credited,
        (COALESCE(SUM(e.Total_amount_charged), 0)-COALESCE(SUM(b.amount_credited), 0)) AS pending_amount
     ')
            ->fromSub(function ($query) {
                $query->selectRaw('branch_code, SUM(Total_amount_charged) AS Total_amount_charged')
                    ->from('enrolment_clients')
                    ->groupBy('branch_code');
            }, 'e')
            ->leftJoinSub(function ($query) {
                $query->selectRaw('branch_code, SUM(amount_credited) AS amount_credited')
                    ->from('bankuplods')
                    ->groupBy('branch_code');
            }, 'b', 'e.branch_code', '=', 'b.branch_code')
            ->groupByRaw('COALESCE(e.branch_code, b.branch_code)');

        $pendingTopPaymentBranch = DB::table(DB::raw("({$pendingResults->toSql()}) as pending_results"))
            ->mergeBindings($pendingResults->getQuery())
            ->select('*')
            ->where('pending_amount', '>', 0)
            ->orderBy('pending_amount', 'DESC')
            ->limit(5)
            ->get();

        // dd($pendingResults,$pendingTopPaymentBranch);


        // dd($pendingTopPaymentBranch);
        $Total_enrollments = EnrollmentClient::select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
        $new_enrollments = EnrollmentClient::where('Type', 'E')->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
        $mandatory_bio_biometric_update = EnrollmentClient::where([['Total_amount_charged', '0.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
        $total_demographic_update = EnrollmentClient::where([['Total_amount_charged', '50.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
        $biometric_update = EnrollmentClient::where([['Total_amount_charged', '100.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();


        $PaymentDeposited = Bankupload::sum('amount_credited');
        $PaymentPending  = (EnrollmentClient::sum('Total_amount_charged') - $PaymentDeposited);
        // dd($PaymentDeposited,$PaymentPending,EnrollmentClient::sum('Total_amount_charged'));
        $lastMisDate  =  EnrollmentClient::orderBy('c_date', 'DESC')->first()->c_date;
        $lastMisDateTime  =  EnrollmentClient::orderBy('c_date', 'DESC')->first()->c_time;


        // Create a Carbon instance from the timestamp
        $carbonDate = Carbon::createFromTimestamp($lastMisDateTime);

        // Format the Carbon instance as desired
        $formattedTime = $carbonDate->format('H:i:s A');
        $lastUpdateOperatorsCount  =  EnrollmentClient::select('Operator_ID')->whereDate('c_date', $lastMisDate)->groupBy('Operator_ID')->get()->toArray();
        // dd($lastUpdateOperatorsCount);
        $lastUpdateOperatorsCount = count($lastUpdateOperatorsCount);
        $allOperator_Code = Operator::where('status', '1')->count();
        $carbonDate = Carbon::now('Asia/Kolkata');
        $totalPresent = Attendance::where([['date', $carbonDate->format('Y-m-d')], ['branch_code', null]])->get();
        // dd($Total_enrollments ,$new_enrollments,$mandatory_bio_biometric_update,$total_demographic_update,$biometric_update);
        return view('admin/dashboard', compact('PaymentPending', 'totalPresent', 'formattedTime', 'allOperator_Code', 'lastUpdateOperatorsCount', 'lastMisDate', 'lastUpdateOperatorsCount', 'PaymentDeposited', 'Total_enrollments', 'new_enrollments', 'mandatory_bio_biometric_update', 'total_demographic_update', 'biometric_update', 'operators', 'enrollmentListTopDailyWise', 'pendingTopPaymentOperator', 'pendingTopPaymentBranch'));
    }
    public function NotOperatorsMis()
    {
        $lastMisDate  =  EnrollmentClient::orderBy('c_date', 'DESC')->first()->c_date;
        $lastUpdateOperatorsCount  =  EnrollmentClient::select('Operator_ID')->whereDate('c_date', $lastMisDate)->groupBy('Operator_ID')->pluck('Operator_ID');

        $operatorList = Operator::whereNotIn('Operator_Code', $lastUpdateOperatorsCount)->where('status', '1')->paginate();

        return view('admin.not-upload-mis-operator', compact('operatorList'));
    }
    public function dashboardAjax(Request $req)
    {
        // dd($req->all());
        if ($req->from_date == 'all') {
            $Total_enrollments = EnrollmentClient::select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $new_enrollments = EnrollmentClient::where('Type', 'E')->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $mandatory_bio_biometric_update = EnrollmentClient::where([['Total_amount_charged', '0.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $total_demographic_update = EnrollmentClient::where([['Total_amount_charged', '50.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $biometric_update = EnrollmentClient::where([['Total_amount_charged', '100.0'], ['Type', 'U']])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            // dd($Total_enrollments,$biometric_update , $total_demographic_update,$mandatory_bio_biometric_update);

            $PaymentDeposited = Bankupload::sum('amount_credited');
            $PaymentPending  = ($Total_enrollments[0]->Total_amount_charged - $PaymentDeposited);
        } else {
            $Total_enrollments = EnrollmentClient::whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $new_enrollments = EnrollmentClient::where('Type', 'E')->whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $mandatory_bio_biometric_update = EnrollmentClient::where([['Total_amount_charged', '0.0'], ['Type', 'U']])->whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $total_demographic_update = EnrollmentClient::where([['Total_amount_charged', '50.0'], ['Type', 'U']])->whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            $biometric_update = EnrollmentClient::where([['Total_amount_charged', '100.0'], ['Type', 'U']])->whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date])->select(DB::raw('COUNT(*) as number'), DB::raw('SUM(Total_amount_charged) as Total_amount_charged'))->get();
            // dd($Total_enrollments,$biometric_update , $total_demographic_update,$mandatory_bio_biometric_update);

            $PaymentDeposited = Bankupload::whereBetween('date_of_transaction', [$req->from_date." 00:00:00", $req->to_date." 23:59:59"])->sum('amount_credited');
            $PaymentPending  = ($Total_enrollments[0]->Total_amount_charged - $PaymentDeposited);
        }


        $html =  view('admin.dashboard-ajax', compact('Total_enrollments', 'PaymentDeposited', 'PaymentPending', 'biometric_update', 'total_demographic_update', 'new_enrollments', 'mandatory_bio_biometric_update'))->render();
        //dd($html); // return \Response::json(['status'=>'success','data'=>$viewHtml]);
        return response()->json(['data' => $html, 'status' => 'success']);
    }
    public function adminChangePassword(Request $req)
    {
        return view('admin/change_password');
    }

    public function PsswordChange(Request $req)
    {

        $user = Session::get('adminsession');

        $validator = Validator::make($req->all(), [
            'old_password' => 'required|min:6|max:50|',
            'new_password' => 'required|min:6|max:255|',
            'confirm_password' => 'required|min:6|max:255|',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withInput($req->input())->withErrors($validator->errors());
        } else if ($req->new_password != $req->confirm_password) {
            return redirect()
                ->back()
                ->with(['message' => 'New Password and Confirm Password does not match', 'alert-type' => 'error']);
        } else  if (!Hash::check($req->old_password, $user->password)) {
            // The passwords matches

            return redirect()
                ->back()
                ->with(['message' => 'Your current password does not matches with the password you provided. Please try again.', 'alert-type' => 'error']);
        } else   if ($req->old_password == $req->new_password) {
            //Current password and new password are same
            // return redirect()
            //     ->back()
            //     ->with('error', 'New Password cannot be same as your current password. Please choose a different password.');

            return redirect()
                ->back()
                ->with(['message' => 'New Password cannot be same as your current password. Please choose a different password.', 'alert-type' => 'error']);
        } else {
            $arrayParam = [
                'password' =>  Hash::make($req->new_password),
            ];

            DB::table('admins')
                ->where('id', $user->id)
                ->update($arrayParam);
            return redirect('/admin/dashboard')->with(['message' => 'Password Updated Successfully', 'alert-type' => 'success']);
        }
        //Change Password
    }

    public function StatusChange(Request $request)
    {
        $Operator = Operator::find($request->id);
        //    dd($Operator);
        if ($Operator) {
            $Operator->status = $request->status;
            $Operator->save();
            $status = 'Status change successfully!';
            $data = 1;
        } else {
            $status = 'fail';
            $data = 0;
        }

        return response()->json(['data' => $data, 'status' => $status]);
    }


    public function attendanceBranch(Request $req)
    {

        $District = Operator::pluck('District')->unique();
        $state = Operator::pluck('State')->unique();
        $branches = Branch::all();
   
        $carbonDate = Carbon::now('Asia/Kolkata');
        $attendances = Attendance::where([['operator_Code', null]])->with(['Branch'])->orderBy('date', 'DESC')
                        ->whereHas('Branch', function ($query) use ($req) {
                            if(isset($req->state)){
                                $query->where('state', $req->state);
                            }
                            if(isset($req->District)){
                                $query->where('District', $req->District);
                            }
                            if(isset($req->branch_code)){
                                $query->where('branch_code', $req->branch_code);
                            }
                        }); 
            if(isset($req->from_date) && isset($req->to_date)){
                $attendances = $attendances->whereBetween('date',[$req->from_date, $req->to_date]);
            }
            if(isset($req->submit) && $req->submit=="Export Excel"){
                $cDate = date('d-m-Y');
                $excel = app(Excel::class);
                $attendances = $attendances->get();
                return $excel->download(new BranchAttendanceEXC($attendances), "Branch-Attendance.$cDate.xlsx");
            }
        $attendances = $attendances->latest()->paginate(50);

        return view('admin.attendance.branch', compact('attendances', 'District', 'state', 'branches'));
    }
    public function attendanceOperator(Request $request)
    {   
       
        $operatorList = Operator::all();
        $District = Operator::pluck('District')->unique();
        $state = Operator::pluck('State')->unique();
       
        $branches = Branch::all();
        $registrars = Registrar::all();
        $carbonDate = Carbon::now('Asia/Kolkata');
        $attendances = Attendance::where([['branch_code', null]])->when($request->operator_code,function($query) use($request){
            return   $query->where('operator_Code',$request->operator_code);
        })->when($request->from_date && $request->to_date,function($query) use($request){
            return   $query->whereBetween('date', [$request->from_date, $request->to_date]);
        })->with(['Operator'=>function($query) use($request){
            return $query->when($request->Ea_Code,function($query) use($request){
                return  $query->where('EA_Code',$request->Ea_Code);
            });
        }]);
        if(isset($request->submit) && $request->submit=='Export Excel'){
            $cDate = date('d-m-Y');
            $excel = app(Excel::class);
            $attendances = $attendances->get();
            return $excel->download(new OperatorAttendanceEXC($attendances), "Operator-Attendance.$cDate.xlsx");
        }
        $attendances = $attendances->orderBy('date', 'DESC')->paginate(30);

        return view('admin.attendance.operator', compact('attendances', 'registrars', 'state', 'branches', 'operatorList', 'District'));
    }
    public function NotAccess()
    {
        return view('admin.not-access');
    }
}
