<?php

namespace App\Http\Controllers\admin;

use App\Models\Admin;
use App\Models\Branch;
use App\Models\Operator;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\EnrollmentClient;
use Illuminate\Support\Facades\{DB, Session};
use App\Http\Controllers\Controller;
use App\Models\EnrollmentClientMissingSerial;
use App\Exports\EnrollmentClientMissingSerialExport;
use Maatwebsite\Excel\Excel;

class AdminEnrollmentControllers extends Controller
{
    public function Index(Request $req)
    {
        if (Session::get('adminsession')) {
            $admin = Admin::where('id', Session::get('adminsession')->id)->first();
            if (DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 30]])->first() || $admin->role == 1) {
                $assing = 1;
            } else {
                return redirect()->route('admin.not.access')->with('error', 'This Model not Assing!');
            }
        }
         if (Session::get('operatorsession')) {
            
            if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','80']])->first()) {
                $assing = 1;
            }else{
                return redirect()->route('operator.not.access')->with('error', 'This Model not Assing!');
            }
        }
        if (Session::has('adminsession')) {
            $lastMisDate  =  EnrollmentClient::orderBy('c_date', 'DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp($lastMisDate->c_time);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');
            return view('admin.enrollment_client', compact('lastMisDate', 'formattedTime'));
        } elseif (Session::has('operatorsession')) {

            $lastMisDate  =  EnrollmentClient::where([['Operator_ID', Session::get('operatorsession')->Operator_Code]])->orderBy('c_date', 'DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp(isset($lastMisDate)?$lastMisDate->c_time:null);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');

            return view('operator.enrollment_client', compact('lastMisDate', 'formattedTime'));
        } elseif (Session::has('branchsession')) {
            $lastMisDate  =  EnrollmentClient::where([['branch_code', Session::get('branchsession')->branch_code]])->orderBy('c_date', 'DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp($lastMisDate->c_time);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');
            return view('branch.enrollment_client', compact('lastMisDate', 'formattedTime'));
        }
    }
    public function enrollmentList(Request $req)
    {
        if (Session::get('adminsession')) {
            $admin = Admin::where('id', Session::get('adminsession')->id)->first();
            // dd($admin,DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 31]])->first());
            if (DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 31]])->first() || $admin->role == 1) {
                // dd('jj');
                $assing = 1;
            } else {
                //  dd('jjll');
                return redirect()->route('admin.not.access')->with('error', 'This Model not Assing!');
            }
        }
        if (Session::get('operatorsession')) {
            
            if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','81']])->first()) {
                $assing = 1;
            }else{
                return redirect()->route('operator.not.access')->with('error', 'This Model not Assing!');
            }
        }
        if (Session::has('adminsession')) {
            if (isset($req->from_date) && isset($req->to_date)) {
                $enrollmentList = EnrollmentClient::select('enrolment_clients.*')
                    ->join('operators', 'enrolment_clients.Operator_ID', '=', 'operators.Operator_Code')
                    ->whereBetween('c_date', [$req->from_date, $req->to_date]);
                if (isset($req->operator)) {
                    $enrollmentList = $enrollmentList->where('enrolment_clients.Operator_ID', $req->operator);
                }
                if (isset($req->district)) {
                    $enrollmentList = $enrollmentList->where('operators.District', $req->district);
                }
                if (isset($req->branch)) {
                    $enrollmentList = $enrollmentList->where('operators.branch_id', $req->branch);
                }
                if (isset($req->registrarscode)) {
                    $enrollmentList = $enrollmentList->where('enrolment_clients.Enrolment_Agency', $req->registrarscode);
                }
                $enrollmentList = $enrollmentList->orderBy('enrolment_clients.aadhar_uid', 'DESC')->paginate(50);
            } else {
                $enrollmentList = [];
            }

            $branchData = Branch::select('branch_code', 'branch_name')->orderBy('branch_name', 'ASC')->get();
            $districtData = Operator::select('District')->groupBy('District')->orderBy('District', 'ASC')->get();
            $state = Operator::select('state')->groupBy('state')->orderBy('state', 'ASC')->get();
            $operatorData = Operator::orderBy('Operator_Code', 'ASC')->get();

            return view('admin.enrollment_client_view', compact('enrollmentList', 'branchData', 'operatorData', 'districtData','state'));
        } else if (Session::has('operatorsession')) {
            $opratorCode = Session::get('operatorsession')->Operator_Code;
            $enrollmentList = EnrollmentClient::where('Operator_ID', $opratorCode)->orderBy('enrolment_clients.aadhar_uid', 'DESC');
            if ($req->from_date && $req->to_date) {
                $enrollmentList = $enrollmentList->whereBetween('c_date', [$req->from_date, $req->to_date]);
            }
            $enrollmentList = $enrollmentList->paginate(50);
            return view('operator.enrollment_client_view', compact('enrollmentList'));
        } else if (Session::has('branchsession')) {
            $districtData = Operator::select('District')->where('branch_id', Session::get('branchsession')->branch_code)->groupBy('District')->orderBy('District', 'ASC')->get();
            $operatorData = Operator::where('branch_id', Session::get('branchsession')->branch_code)->orderBy('Operator_Code', 'ASC')->get();
            $branch_code = Session::get('branchsession')->branch_code;
            $state = Operator::select('state')->where('branch_id', Session::get('branchsession')->branch_code)->groupBy('state')->orderBy('state', 'ASC')->get();
            $enrollmentList = EnrollmentClient::where('branch_code', $branch_code)->orderBy('enrolment_clients.aadhar_uid', 'DESC');
            if ($req->from_date && $req->to_date) {
                $enrollmentList = $enrollmentList->whereBetween('c_date', [$req->from_date, $req->to_date]);
            }
            if (isset($req->operator)) {
                if ($req->operator == 'All') {
                } else {
                    $enrollmentList = $enrollmentList->where('enrolment_clients.Operator_ID', $req->operator);
                }
            }
            $enrollmentList = $enrollmentList->paginate(50);
            return view('branch.enrollment_client_view', compact('enrollmentList', 'districtData', 'operatorData','state'));
        }
    }
    
       public function enrollmentListMissingSerial(Request $request)
    {
        // dd($request->all());
        $enrollmentList = EnrollmentClientMissingSerial::with(['Branch', 'Operator'])
            ->when($request->branch, function ($query) use ($request) {
                return $query->where('branch_code', $request->branch);
            })->when($request->operator, function ($query) use ($request) {
                return $query->where('operator_code', $request->operator);
            })->when($request->to_date && $request->from_date, function ($query) use ($request) {
                return $query->whereBetween('created_at', [$request->from_date, $request->to_date]);
            })->whereHas('operator', function ($query) use ($request) {
                $query->where(function ($subQuery) use ($request) {
                    $subQuery->when(isset($request->EA_Code), function ($query) use ($request) {
                        $query->where('EA_Code', $request->EA_Code);
                    });

                    $subQuery->when(isset($request->state), function ($query) use ($request) {
                        $query->where('State', $request->state);
                    });

                    $subQuery->when(isset($request->district), function ($query) use ($request) {
                        $query->where('District', 'like', "%$request->district%");
                    });

                    $subQuery->when(isset($request->branch_code), function ($query) use ($request) {
                        $query->where('branch_code', $request->branch_code);
                    });

                    $subQuery->when(isset($request->operator_code), function ($query) use ($request) {
                        $query->where('operator_code', $request->operator_code);
                    });
                });

                // Additional conditions can be added here
            });
            if(isset($request->submit) && $request->submit=='Export Excel'){
                $enrollmentList = $enrollmentList->get();
                $cDate = date('d-m-Y');
                $excel = app(Excel::class);
                return $excel->download(new EnrollmentClientMissingSerialExport($enrollmentList), "Enrollment_Client_Missing_Serial_report_.$cDate.xlsx");
            }
          $enrollmentList =  $enrollmentList->paginate();
        $branchData = Branch::select('branch_code', 'branch_name')->orderBy('branch_name', 'ASC')->get();
        $districtData = Operator::select('District')->groupBy('District')->orderBy('District', 'ASC')->get();
        $state = Operator::select('state')->groupBy('state')->orderBy('state', 'ASC')->get();
        $operatorData = Operator::orderBy('Operator_Code', 'ASC')->get();
        return view('admin.enrollment_client_serial', compact('enrollmentList', 'districtData', 'branchData', 'operatorData', 'state'));
    }
}
