<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Registrar;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\AlertMessage;
use Illuminate\Support\Facades\{DB, Session};
use Validator;

class RegistraCodeController extends Controller
{
    public function index(){
         if (Session::get('adminsession')) {
            $admin = Admin::where('id', Session::get('adminsession')->id)->first();
            if (DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 27]])->first() || $admin->role == 1) {
                $assing = 1;
            } else {
                return redirect()->route('admin.not.access')->with('error', 'This Model not Assing!');
            }
        }
        $data = Registrar::all();
        return view('admin.registrar.create',compact('data'));
    }
    public function edit($id){
        $dataUpdate = Registrar::where('id',$id)->first();
        $data = Registrar::all();
        return view('admin.registrar.create',compact('dataUpdate','data'));
    }

    public function delete($id){
        $dataUpdate = Registrar::where('id',$id)->delete();

        return redirect()->back()->with('success','Delete successfully!');
    }

    public function store(Request $request){
        $validator = Validator::make($request->all(), [ 
            'Registrar_code' => 'required|unique:registrars,Registrar_code', 
            'Registrar_Name' => 'required', 
            'EA_Code'        => 'required', 
            'EA_Name'        => 'required'
        ]);
        
        if ($validator->fails()) { 
            return redirect()
                ->back()
                ->withInput($request->input())
                ->withErrors($validator->errors());
        }

        if($request->add == 'yes'){
            $data =  Registrar::where('id',$request->id)->first();
            $data->status =  $request->Status;
        }else{
            $data = new Registrar();
            $data->status = $request->Status;

        }

        $data->Registrar_code = $request->Registrar_code;
        $data->Registrar_Name = $request->Registrar_Name;
        $data->Ea_Code = $request->EA_Code;
        $data->Ea_Name = $request->EA_Name;
        $data->save();
        if($request->add == 'yes'){
            return redirect()->route('registrar.index')->with(['message'=>'Status Update successfully!','alert-type'=>'success']);
        }
        return redirect()->back()->with(['alert-type'=>'success','message'=>'Create successfully!']);
    }


    public function StatusUpdate(Request $request,$id){

        $data = Registrar::where('id',$id)->first();
        $data->status = $request->status;
        $data->save();
        return back()->with(['message'=>'Status Update successfully!','alert-type'=>'success']);
    }


    public function alertMessageIndex (){
    //     if (Session::get('adminsession')) {
    //        $admin = Admin::where('id', Session::get('adminsession')->id)->first();
    //        // dd($admin,DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 27]])->first());
    //        if (DB::table('model_has_roles')->where([['role_id', $admin->role], ['model_id', 27]])->first() || $admin->role == 1) {
    //            // dd('jj');
    //            $assing = 1;
    //        } else {
    //            //  dd('jjll');
    //            return redirect()->route('admin.not.access')->with('error', 'This Model not Assing!');
    //        }
    //    }
       $data = AlertMessage::all();
       return view('admin.alert.create',compact('data'));
   }

   public function alertMessageStore(Request $request){
   
        $data =  AlertMessage::where('id',$request->id)->first();
    

        $data->content = $request->content;
        $data->status = !empty($request->status)? 1: 0;
        
        $data->save();
        return back()->with(['message'=>'Status Update successfully!','alert-type'=>'success']);
    }

}
