<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Salary;
use Carbon\Carbon;
use App\Models\Operator;
use App\Models\Attendance;

class SalaryController extends Controller
{
    public function salaryCalculation(){
         $currentMonth = Carbon::now();
         $pastMonth = Carbon::now()->subMonth(); // Get the timestamp for the first day of the previous month

         if (Salary::whereMonth('created_at', $currentMonth->month)->whereYear('created_at', $currentMonth->year)->doesntExist()) {
           
         $operatorList = Operator::select('operators.Operator_Code', 'operators.branch_id','operators.Salary','operators.PF_No','operators.ESI_No')
                        ->join('attendances','operators.Operator_Code','=','attendances.operator_Code')
                        ->groupBy('operators.Operator_Code', 'operators.branch_id','operators.Salary','operators.PF_No','operators.ESI_No')
                        ->orderBy('operators.Operator_Code','ASC')
                        ->get();
            
             $dataArray = [];
             foreach ($operatorList as $operator) {
               
                 $attendanceData = Attendance::select('attendances.*')
                                ->whereMonth('created_at', $pastMonth->month)
                                ->whereYear('created_at', $pastMonth->year)
                                ->where('operator_Code',$operator->Operator_Code)
                                ->get();
              
                if(!empty($attendanceData->toArray())){
                  
                 $countAttendance = $attendanceData->count();
                 $countFullDays = $attendanceData->filter(fn ($val) => $val->persent_type >= 8)->count();
                 $cHDay = $countAttendance - $countFullDays;
                 if($cHDay==0){
                    $countHalfDay = $cHDay;
                 }else{
                    $countHalfDay = $cHDay/2;
                 }
                 $oneDaySalary = $operator->Salary / 30;
                 $fullDay = $countFullDays * $oneDaySalary;
                 $halfDay = $countHalfDay * $oneDaySalary;
         
                 $TOTAL = $fullDay + $halfDay;
                 $employee_ESIC = ($TOTAL * 0.75) / 100;
                 $employee_PF = ($TOTAL * 12) / 100;
                 $employer_ESIC = ($TOTAL * 3.25) / 100;
                 $employer_PF = ($TOTAL * 13) / 100;
                 $netSalary = $TOTAL - ($employee_ESIC + $employee_PF);
         
                 $dataArray[] = [
                     'branch_code' => $operator->branch_id,
                     'operator_code' => $operator->Operator_Code,
                     'total_present_in_month' => $countAttendance,
                     'payout' => $operator->Salary,
                     'ESIC' => round($employee_ESIC,3),
                     'PF' => round($employee_PF,3),
                     'Employer_ESIC' => round($employer_ESIC,3),
                     'Employer_PF' => round($employer_PF,3),
                     'TOTAL' => round($TOTAL,3),
                     'Net_Salary' => round($netSalary),
                     'PF_NO' => $operator->PF_No,
                     'ESI_NO' => $operator->ESI_No,
                     'total_fullday_count' => $countFullDays,
                     'total_halfday_count' => $cHDay,
                     'salary_date'         => '30-'.$pastMonth->month.'-'.$pastMonth->year
                 ];

                }
            }
             if(!empty($dataArray)){
                Salary::insert($dataArray);
                return back()->with(['message'=>'Salary generated!','alert-type'=>'success']);
             }else{
                return back()->with(['message'=>'Operator Not Found!','alert-type'=>'error']);
             }
             
            }else{
              return back()->with(['message'=>'Salary  already generate!','alert-type'=>'error']);
         }
    }
}
