<?php

namespace App\Http\Controllers\operator;

use Session;
use DateTime;
use Validator;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Operator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;

class OperatorAtuthController extends Controller
{
    public function Index(Request $req){
        $data = array();

            if($req->isMethod('post')){


                $validator = Validator::make($req->all(), [
                    'operator_code' => 'required',
                    'password'      => 'required',
                ]);
                if ($validator->fails()) {
                    return redirect()
                        ->back()
                        ->withInput($req->input())
                        ->withErrors($validator->errors());
                }

                $userbefor = Operator::where(['Operator_Code'=>$req->operator_code])->first();
                // dd(new DateTime('now'));
                $mytime = Carbon::now('Asia/Kolkata');
                // dd($mytime->toDateTimeString());
                if($userbefor){
                    $userbefor->last_login = $userbefor->current_login;
                    $userbefor->current_login = $mytime->toDateTimeString();
                $userbefor->save();
                }

                $user = Operator::where(['Operator_Code'=>$req->operator_code])->first();
                if($user) {
                    if($user->status == '1'){
                        if(!Hash::check($req->password, $user->password)){
                            $data['error'] = "Password does not match";
                        }else{
                            Session::forget('adminsession');
                            Session::forget('branchsession');
                            $req->session()->put('operatorsession', $user);
                            return  redirect('operator/dashboard');
                        }
                    }else{
                        if($user->status == '0'){
                            $data['error'] = "Your profile Blacklisted!";
                        }
                        if($user->status == '2'){
                            $data['error'] = "Your profile Inactive!";
                        }
                        if($user->status == '3'){
                            $data['error'] = "Your profile Disassociated!";
                        }
                    }

                }else{
                    $data['error'] = "Username and Password is not matched";
                }
            }

            if(session()->has('operatorsession')){
                return  redirect('operator/dashboard');
            }else{
                return view('operator.index', ['data'=>$data]);
            }
    }

    public function logout(Request $request){


        // $request->session()->flush();
        Session::forget('operatorsession');
        return redirect('/operator-login');
    }

}
