<?php

namespace App\Imports;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\EnrollmentClient;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Hash;
use App\Models\Bankupload;

class Bankimport implements ToCollection ,WithHeadingRow
{
     /**
    * @param Collection $collection
    */
    private $data = array();

    public function collection(Collection $rows){


    try {
        DB::beginTransaction();

        $uploadData = [];
        foreach ($rows->toArray() as $row) {

            if($row['date_of_transaction']){

            if(Bankupload::where('transaction_no',$row['transaction_no'])->first() == null ){
                // dd($row);
                $dateField = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['date_of_transaction']);
                $uploadData[] = [
                    'date_of_transaction' => $dateField,
                    'registrar_code'      => $row['registrar_code'],
                    'ea_code'             => $row['ea_code'],
                    'state'               => $row['state'],
                    'district'            => $row['district'],
                    'Operator_Code'        => $row['operator_code'],
                    'branch_code'        => isset($row['branch_code']) ? $row['branch_code'] : DB::table('operators')->where('Operator_Code',$row['operator_code'])->first()->branch_id,
                    'station_code'        => $row['station_code'],
                    'amount_credited'     => $row['amount_credited'],
                    'admin_id'            => Session::get('adminsession')->id,
                    'transaction_no'      => $row['transaction_no']
                ];
            }

         }

        }

        // dd($uploadData);

        Bankupload::insert($uploadData);

        DB::commit();

    } catch (Exception $e) {
       // dd($uploadData);
        // dd('jj');
        DB::rollBack();
        $this->data =  $e->getMessage();
    }

    }
     // Specify header row index position to skip
     public function headingRow(): int {
        return 1;
     }
     public function getMessage(){
        return $this->data;
    }
}
