<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Salary extends Model
{
    protected $table = "salaries";
    protected $fillable = ["branch_code","operator_code","total_present_in_month","payout","ESIC","PF","Employer_ESIC","Employer_PF","TOTAL","Net_Salary","PF_NO","ESI_NO","total_fullday_count","total_halfday_count","salary_date"];

    public function operator(){
        return $this->hasOne(Operator::class,'Operator_Code','operator_code');
    }
    public function branch(){
        return $this->hasOne(Branch::class,'branch_code','branch_code');
    }
}
