<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithDrawings;
use DB;

class BranchDueExcel implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
         foreach($this->data as $item) {
            ++$i;
            $itemArray = [
                    'S.NO'                      => $i,
                    'Branch Name'=>$item['branch_name'],
                    'District'=>$item['district'],
                    'Operator ID'=>$item['Operator_Code'],
                    'Operator Name'=>$item['Operator_Name'],
                    'Station Code'=>$item['Station_Code'],
                    'Total No of Enrollment'=>$item['total_No_of_Enrollment'],
                    'Total No of update'=>$item['total_no_of_update'],
                    'New Enrollments'=>$item['new_enrollments'],
                    'Demographic Updates'=>$item['total_demographic_update'],
                    'Mandatory Biometric Updates(5/15 years)'=>$item['mandatory_bio_biometric_update'],
                    'Biometric Updates'=>$item['biometric_update'],
                    'Total Amount Collected Towards Demographic Updates.'=>$item['total_amount_collected_A'],
                    'Total Amount Collected Towards Biometric Updates'=>$item['total_amount_collected_B'],
                    'Total payment collected by Operators'=>$item['total_collect_amount'],
                    'Total payment Deposited by Operators / Branch'=>$item['total_deposit_bank'],
                    'Dues on Operator / Branch'=>$item['total_collect_amount']-$item['total_deposit_bank'],
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }
 

   
    public function headings(): array
    {

        return ['S.NO', 'Branch Name', 'District', 'Operator ID', 'Operator Name', 'Station Code','Total No of Enrollment','Total No of update','New Enrollments','Demographic Updates','Mandatory Biometric Updates(5/15 years)','Biometric Updates','Total Amount Collected Towards Demographic Updates.','Total Amount Collected Towards Biometric Updates', 'Total payment collected by Operators', 'Total payment Deposited by Operators / Branch', 'Dues on Branch'];
    }
}