<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithDrawings;
use DB;

class FundDepositEXC implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
        foreach($this->data as $item) {
            ++$i;
            $itemArray = [
                    'S.NO'                           => $i,
                    'Transaction Date'               => date('d-m-Y',strtotime($item->date_of_transaction)),
                    'Branch'                         => $item->branch_name,
                    'District'                       => $item->district,
                    'Operator ID'                    => $item->Operator_Code,
                    'Operator Name'                  => $item->Operator_Name,
                    'Station Code'                   => $item->Station_Code,
                    'Transaction Amount'             => $item->amount_credited,
                    'Transaction Number'             => $item->transaction_no,
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }
 

   
    public function headings(): array
    {

        return ['S.NO', 'Transaction Date', 'Branch', 'District', 'Operator ID', 'Operator Name', 'Station Code', 'Transaction Amount', 'Transaction Number'];
    }
}