<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Collection;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithDrawings;
use DB;

class TotalEIDExcel implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        $collection = new Collection();
        $i = 0;
        
        foreach($this->data as $item) {
            ++$i;
            $itemArray = [
                    'S.NO'                 => $i,
                    'Branch'               => $item->branch_name,
                    'District'             => $item->district,
                    'Operator ID'          => $item->Operator_ID,
                    'Operator Name'        => $item->Operator_Name,
                    'Station Code'         => $item->Station_ID,
                    'Date of Enrolment'    => date('d-m-Y', strtotime($item->c_date)),
                    'EID of Enrolment'     => $item->Enrolment_No_and_Date,
                    'Type of Enrolment'    => $item->Type,
                    'Resident Name'        => $item->Resident,
                    'Charged Amount'       => $item->Total_amount_charged
                ];

            $collection->push($itemArray);
        }
        return $collection;

    }
 

   
    public function headings(): array
    {

        return ['S.NO', 'Branch', 'District', 'Operator ID', 'Operator Name', 'Station Code', 'Date of Enrolment', 'EID of Enrolment', 'Type of Enrolment','Resident Name','Charged Amount'];
    }
}