<?php

namespace App\Http\Controllers;

use App\Models\Operator;
use Illuminate\Http\Request;
use Validator;
use Session;
use Illuminate\Support\Facades\Hash;

class BranchOperatorController extends Controller
{
    //


    public function Index(Request $request){

        if($request->isMethod('post')){

            // dd($request->all());

            $validator = Validator::make($request->all(), [ 
                'Email_ID' => 'required|email|unique:operators', 
                'password' => 'required', 
            ]);
            if ($validator->fails()) { 
                return redirect()
                    ->back()
                    ->withInput($request->input())
                    ->withErrors($validator->errors());
            }

            $branch_id = Session::get('branchsession')->id;

            $operatorObj = new Operator();

            $operatorObj->Registrar_Code = $request->Registrar_Code;
            $operatorObj->EA_Code = $request->EA_Code;
            $operatorObj->Operator_Code = $request->Operator_Code;
            $operatorObj->Operator_Name = $request->Operator_Name;
            $operatorObj->Aadhaar_Number = $request->Aadhaar_Number;
            $operatorObj->SALARY = $request->SALARY;
            $operatorObj->PF_No = $request->PF_No;
            $operatorObj->ESI_No = $request->ESI_No;
            $operatorObj->Station_Code = $request->Station_Code;
            $operatorObj->NSE_IT_Certificate = $request->NSE_IT_Certificate;
            $operatorObj->VTC_Village_Town_City = $request->VTC_Village_Town_City;
            $operatorObj->Post_Office = $request->Post_Office;
            $operatorObj->Block = $request->Block;
            $operatorObj->District = $request->District;
            $operatorObj->State = $request->State;
            $operatorObj->Center_Address = $request->Center_Address;
            $operatorObj->Email_ID = $request->Email_ID;
            $operatorObj->Mobile_No = $request->Mobile_No;
            $operatorObj->Any_Desk_ID = $request->Any_Desk_ID;
            $operatorObj->password = Hash::make($request->password);
            $operatorObj->view_passsword = $request->password;

            $operatorObj->status = !empty($request->status) ? 1 : 0;

            $operatorObj->branch_id = $branch_id;
            $res =  $operatorObj->save();

            if($res){
                return redirect('branch/view-operators')->with(['message'=>'Operators Added Successfully !','alert-type'=>'success']);
            }
        }
        return view('branch.add-operator');
    }

    public function ViewOperator(){

        $branch_id = Session::get('branchsession')->id;
        $operatorList = Operator::orderBy('id','DESC')->where('branch_id',$branch_id)->get();
        return view('branch.view-operator',compact('operatorList'));
    }
}
