<?php

namespace App\Http\Controllers\admin;

use Session;
use Validator;
use App\Models\Branch;
use App\Models\Operator;
use App\Models\Bankupload;
use App\Imports\Bankimport;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class AdminBankUploadControllers extends Controller
{
    public function bankUpload(Request $request){
      if($request->isMethod('post')){
         $validator = Validator::make($request->all(), [
            'excel_file' => 'required|mimes:xls,xlsx',
        ]);
        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withInput($request->input())
                ->withErrors($validator->errors());
        }

         if ($request->hasFile('excel_file')) {
            try{
                $import = new Bankimport;
                Excel::import($import, request()->file('excel_file'));

                 $notification = array(
                    'message' => 'Excel upload Successfully!',
                    'alert-type' => 'success'
                );
              if(Session::get('adminsession')){
                return redirect('admin/receive-amount-list')->with($notification);
              }
              if(Session::get('operatorsession')){
                return redirect('operator/receive-amount-list')->with($notification);
              }
              if(Session::get('adminsession')){
                return redirect('branch/receive-amount-list')->with($notification);
              }


             }catch (\Exception $e) {
                   $notification = array(
                    'message' => $e->getMessage(),
                    'alert-type' => 'error'
                );
                  return back()->with($notification);
             }
        }
      }
      if(Session::get('adminsession')){
        return view('admin.bank_upload');
      }else if(Session::get('operatorsession')){
        return view('operator.bank_upload');
      }else if(Session::get('branchsession')){
        return view('branch.bank_upload');
      }

    }
    public function bankList(Request $req){
       if(Session::has('adminsession')){
        $branchData = Branch::select('branch_code','branch_name')->orderBy('branch_name','ASC')->get();
        $districtData = Operator::select('District')->groupBy('District')->orderBy('District','ASC')->get();
        $operatorData = Operator::orderBy('Operator_Code','ASC')->get();
          $List = Bankupload::latest();
          if($req->from_date && $req->to_date){
            $List = $List->whereBetween('date_of_transaction', [$req->from_date, $req->to_date]);
        }
          if(isset($req->operator)){
            $List = $List->where('Operator_Code',$req->operator);
        }
        if(isset($req->district)){
            $List = $List->where('district',$req->district);
        }
        if(isset($req->branch)){
            $List = $List->where('branch_code',$req->branch);
        }
          if(isset($req->registrarscode)){

            $List = $List->where('enrolment_clients.Registrar',$req->registrarscode);
        }
        $List = $List->paginate(50);
          return view('admin.bank_upload_list', compact('List','operatorData','branchData','districtData'));
       }else if(Session::has('operatorsession')){
          $stationCode = Session::get('operatorsession')->Station_Code;
          $List = Bankupload::where('station_code',$stationCode)->latest()->paginate(50);
          return view('operator.bank_upload_list', compact('List'));
       }else if(Session::has('branchsession')){
        // dd(Session::get('branchsession'));
        $districtData = Operator::select('District')->groupBy('District')->orderBy('District','ASC')->get();
        $operatorData = Operator::where('branch_id',Session::get('branchsession')->branch_code)->orderBy('Operator_Code','ASC')->get();
        $List = Bankupload::where('branch_code',Session::get('branchsession')->branch_code)->latest();
        if($req->from_date && $req->to_date){
          $List = $List->whereBetween('date_of_transaction', [$req->from_date, $req->to_date]);
      }
        if(isset($req->operator)){
          $List = $List->where('Operator_Code',$req->operator);
      }
      if(isset($req->district)){
          $List = $List->where('district',$req->district);
      }
      if(isset($req->branch)){
          $List = $List->where('branch_code',$req->branch);
      }
        if(isset($req->registrarscode)){

          $List = $List->where('enrolment_clients.Registrar',$req->registrarscode);
      }
      $List = $List->paginate(50);
          return view('branch.bank_upload_list', compact('List','operatorData','districtData'));
       }
     }
}
