<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EnrollmentClient;
use Session;
use Illuminate\Support\Carbon;
use App\Models\Branch;
use App\Models\Operator;

class AdminEnrollmentControllers extends Controller
{
    public function Index(Request $req){
        if(Session::has('adminsession')){
            $lastMisDate  =  EnrollmentClient::orderBy('id','DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp($lastMisDate->c_time);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');
            return view('admin.enrollment_client',compact('lastMisDate','formattedTime'));
        }elseif(Session::has('operatorsession')){

            $lastMisDate  =  EnrollmentClient::where([['Operator_ID',Session::get('operatorsession')->Operator_Code]])->orderBy('id','DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp($lastMisDate->c_time);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');

            return view('operator.enrollment_client',compact('lastMisDate','formattedTime'));
        }elseif(Session::has('branchsession')){
            $lastMisDate  =  EnrollmentClient::where([['branch_code',Session::get('branchsession')->branch_code]])->orderBy('id','DESC')->first();
            // Create a Carbon instance from the timestamp
            $carbonDate = Carbon::createFromTimestamp($lastMisDate->c_time);
            // Format the Carbon instance as desired
            $formattedTime = $carbonDate->format('H:i:s A');
            return view('branch.enrollment_client',compact('lastMisDate','formattedTime'));
        }
    }
    public function enrollmentList(Request $req){
        if(Session::has('adminsession')){
            if(isset($req->from_date) && isset($req->to_date)){
                $enrollmentList = EnrollmentClient::select('enrolment_clients.*')
                                ->join('operators','enrolment_clients.Operator_ID','=','operators.Operator_Code')
                                ->whereBetween('c_date', [$req->from_date, $req->to_date]);
                                if(isset($req->operator)){
                                    $enrollmentList = $enrollmentList->where('enrolment_clients.Operator_ID',$req->operator);
                                }
                                if(isset($req->district)){
                                    $enrollmentList = $enrollmentList->where('operators.District',$req->district);
                                }
                                if(isset($req->branch)){
                                    $enrollmentList = $enrollmentList->where('operators.branch_id',$req->branch);
                                }
                                  if(isset($req->registrarscode)){

                                    $enrollmentList = $enrollmentList->where('enrolment_clients.Registrar',$req->registrarscode);
                                }
                                $enrollmentList = $enrollmentList->orderBy('enrolment_clients.aadhar_uid','DESC')->paginate(50);


            }else{
                $enrollmentList = [];
            }

            $branchData = Branch::select('branch_code','branch_name')->orderBy('branch_name','ASC')->get();
            $districtData = Operator::select('District')->groupBy('District')->orderBy('District','ASC')->get();
            $operatorData = Operator::orderBy('Operator_Code','ASC')->get();

            return view('admin.enrollment_client_view', compact('enrollmentList','branchData','operatorData','districtData'));
        }else if(Session::has('operatorsession')){
            $opratorCode = Session::get('operatorsession')->Operator_Code;
            $enrollmentList = EnrollmentClient::where('Operator_ID', $opratorCode)->orderBy('enrolment_clients.aadhar_uid','DESC');
            if($req->from_date && $req->to_date){
                $enrollmentList = $enrollmentList->whereBetween('c_date', [$req->from_date, $req->to_date]);
            }
            $enrollmentList =$enrollmentList->paginate(50);
            return view('operator.enrollment_client_view', compact('enrollmentList'));
        }else if(Session::has('branchsession')){
            // dd(Session::get('branchsession'));
            $districtData = Operator::select('District')->where('branch_id',Session::get('branchsession')->branch_code)->groupBy('District')->orderBy('District','ASC')->get();
            $operatorData = Operator::where('branch_id',Session::get('branchsession')->branch_code)->orderBy('Operator_Code','ASC')->get();
            $branch_code = Session::get('branchsession')->branch_code;
            $enrollmentList = EnrollmentClient::where('branch_code', $branch_code)->orderBy('enrolment_clients.aadhar_uid','DESC');
            if($req->from_date && $req->to_date){
                $enrollmentList = $enrollmentList->whereBetween('c_date', [$req->from_date, $req->to_date]);
            }
             if(isset($req->operator)){
                 if($req->operator == 'All'){

                 }else{
                    $enrollmentList = $enrollmentList->where('enrolment_clients.Operator_ID',$req->operator);
                 }
                }
            $enrollmentList =$enrollmentList->paginate(50);
            return view('branch.enrollment_client_view', compact('enrollmentList','districtData','operatorData'));
        }
    }
}
