<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Operator;
use App\Models\EnrollmentClient;

class AdminReportControllers extends Controller
{
    public function operatorReport(Request $req){
       
        $data = [];
        if(isset($req->operator_code)){
            $enrData = EnrollmentClient::select('enrolment_clients.*','operators.Operator_Name','operators.Registrar_Code','operators.EA_Code')
                        ->join('operators', 'enrolment_clients.Operator_ID','=','operators.Operator_Code')
                        ->where('enrolment_clients.Operator_ID', $req->operator_code);
                        if($req->from_date && $req->to_date){
                            $enrData = $enrData->whereBetween('enrolment_clients.c_date', [$req->from_date, $req->to_date]);
                        }
                       $enrData = $enrData->get();

           $AmountCollected_A = 0;
           $AmountCollected_B = 0;
           $AmountCollected_BB = 0;
           
           $AmountCollected_C = 0;
           $Total_Amount_X = 0;
           
           $Total_New_Enrollment = 0;
           $Total_Demographic_Update = 0;
           $Total_Biometric_Updates = 0;
           $Total_Mandatory_Biometric_Updates = 0;
          
           foreach($enrData as $key=>$val){
            
                if($val->Type=='U'){
                    if($val->Mandatory_biometric_update=='No' && $val->Total_amount_charged==50.0){
                        
                        ++$Total_Demographic_Update;
                    }
                    if($val->Mandatory_biometric_update=='No' && $val->Total_amount_charged==100.0){
                        
                        ++$Total_Biometric_Updates;
                    }
                    if($val->Mandatory_biometric_update=='Yes' && $val->Total_amount_charged==0.0){
                        $AmountCollected_B += $val->Total_amount_charged;
                        ++$Total_Mandatory_Biometric_Updates;
                    }
                    #total count
                    if($val->Total_amount_charged==50.0){
                        $AmountCollected_A += $val->Total_amount_charged;
                    }
                    if($val->Total_amount_charged==100.0){
                        $AmountCollected_B += $val->Total_amount_charged;
                    }
                }else if($val->Type=='E'){
                    ++$Total_New_Enrollment;
                }

           }
           
           $Total_Amount_X = ($AmountCollected_A + $AmountCollected_B + $AmountCollected_C);
            $Operator_ID   = "";
            $Operator_Name = "";
            $Station_Code  = "";
            $EA_Code       = "";
            $Registrar_Code = "";

           if(count($enrData)>0){
                $Operator_ID   = $enrData[0]['Operator_ID'];
                $Operator_Name = $enrData[0]['Operator_Name'];
                $Station_Code  = $enrData[0]['Station_ID'];
                $EA_Code       = $enrData[0]['EA_Code'];
                $Registrar_Code = $enrData[0]['Registrar_Code'];
           }
          
           $data = [
                    'AmountCollected_A' => $AmountCollected_A,
                    'AmountCollected_B' => $AmountCollected_B,
                    'AmountCollected_BB' => $AmountCollected_BB,
                    'AmountCollected_C' => 0,
                    'Total_Amount_X'    => $Total_Amount_X,
                    'Operator_ID'       => $Operator_ID,
                    'Operator_Name'     => $Operator_Name,
                    'Station_Code'      => $Station_Code,
                    'Registrar_Code'    => $Registrar_Code,
                    'EA_Code'           => $EA_Code,
                    'New_Enrolment'     => $Total_New_Enrollment,
                    'Biometric_Update'  => $Total_Biometric_Updates,
                    'Mandatory_Biometric_Updates' => $Total_Mandatory_Biometric_Updates,
                    'Demographic_Update' => $Total_Demographic_Update,
                    'Demographic_with_Biometric_Update'=> ($Total_Mandatory_Biometric_Updates+$Total_Demographic_Update),
                    
                ];
        }
        
        return view('admin.report', compact('data'));
    }
    public function branchReport(){
        $List = [];
        return view('admin.branch_report', compact('List'));
    }
}
