<?php

namespace App\Imports;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\EnrollmentClient;
use DB;
use Session;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Hash;

class UsersImport implements ToCollection ,WithHeadingRow
{
     /**
    * @param Collection $collection
    */
    private $data = array();

    public function collection(Collection $rows){
       
      
    try {
        DB::beginTransaction();
        
       
        foreach ($rows->toArray() as $row) {
            
            $operatorsObj = new EnrollmentClient();
            $operatorsObj->admin_id                = Session::get('adminsession')->id;
            $operatorsObj->Registrar               = substr($row['enrolment_no_and_date'], 1,3);
            $operatorsObj->Station_ID              = substr($row['enrolment_no_and_date'], 4,5);
            $operatorsObj->Enrolment_Agency        = substr($row['enrolment_no_and_date'], 0, 4);
            $c_date = substr($row['enrolment_no_and_date'], 15, 4).'-'.substr($row['enrolment_no_and_date'],19, 2).'-'.substr($row['enrolment_no_and_date'], 21, 2);
            $operatorsObj->aadhar_uid              = substr($row['enrolment_no_and_date'], 9, 5);
            $operatorsObj->c_date                  = $c_date;
            $operatorsObj->c_time                  = substr($row['enrolment_no_and_date'], 23, 4);
            $operatorsObj->Enrolment_No_and_Date   = $row['enrolment_no_and_date'];
            $operatorsObj->Appointment_Id          = $row['appointment_id'];
            $operatorsObj->Type                    = $row['station_id'];
            $operatorsObj->Mandatory_biometric_update = $row['mandatory_biometric_update'];
            $operatorsObj->IS_NRI                  = $row['is_nri'];
            $operatorsObj->Tin_Number              = $row['tin_number'];
            $operatorsObj->Operator_ID             = $row['operator_id'];
            $operatorsObj->Reviewer_ID             = $row['reviewer_id'];
            $operatorsObj->Introducer              = $row['introducer'];
            $operatorsObj->Proof                   = $row['proof'];
            $operatorsObj->Resident                = $row['resident'];
            $operatorsObj->Status                  = $row['status'];
            $operatorsObj->Introducer_Review_Status= $row['introducer_review_status'];
            $operatorsObj->User_Review_Status      = $row['user_review_status'];
            $operatorsObj->GSApplied_Percentage    = $row['gsapplied_percentage'];
            $operatorsObj->Amount_charged_for_New_Enrolment     = $row['amount_charged_for_new_enrolment'];
            $operatorsObj->Amount_charged_for_Update_Enrolment  = $row['amount_charged_for_update_enrolment'];
            $operatorsObj->Total_amount_charged    = $row['total_amount_charged'];
            
            $operatorsObj->save();
        }
        DB::commit();

    } catch (Exception $e) {
       
        DB::rollBack();
        $this->data =  $e->getMessage();
    }
      
    }
     // Specify header row index position to skip
     public function headingRow(): int {
        return 1;
     }
     public function getMessage(){
        return $this->data;
    }
}
