<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnrollmentClient extends Model
{
    use HasFactory;
    protected $table = "enrolment_clients";
    protected $fillable = ["Registrar","branch_code","Station_ID","Enrolment_Agency","Enrolment_No_and_Date","Appointment_Id","Type","Mandatory_biometric_update","IS_NRI","Tin_Number","Operator_ID","Reviewer_ID","Introducer","Proof","Resident","Status","Introducer_Review_Status","User_Review_Status","GSApplied_Percentage","Amount_charged_for_New_Enrolment","Amount_charged_for_Update_Enrolment","Total_amount_charged","admin_id","aadhar_uid","c_date","c_time"];

    public function BankUpload(){
        return $this->hasMany(Bankupload::class,'Operator_Code','Operator_ID');
    }

    public function Operator(){
        return $this->hasOne(Operator::class,'Operator_Code','Operator_ID');
    }
    public function Branch(){
        return $this->hasOne(Branch::class,'branch_code','branch_code');
    }
    public function BankUploadBranch(){
        return $this->hasMany(Bankupload::class,'branch_code','branch_code');
    }
}
