@extends('admin.layouts.master')
@section('main-content')
@php
$mytime = Carbon\Carbon::now('Asia/Kolkata');
 use Carbon\Carbon;
@endphp
<style>
    /* Add your CSS styles here */



    input[type="submit"] {
        padding: 10px;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }
</style>
<main>
    <div class="container">
        <h2 class="mt-5 mb-4">Attendance of Branch</h2>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">

                    </div>
                    <div class="responsive">
                        <form action="{{url('/admin/attendance/attendance-branches')}}" method="get">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>From Date</label>
                                    <input type="date" name="from_date" id="from_date" class="form-control"
                                        value="{{Request::get('from_date')}}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>To Date</label>
                                    <input type="date" name="to_date" id="to_date" class="form-control"
                                        value="{{Request::get('to_date')}}">
                                </div>
                            </div>
                           
                            
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($state as $key=>$state)
                                        <option value="{{$state}}" {{Request::get('state')==$state ? "selected" :''}}>
                                            {{$state}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>District </label>
                                    <select name="District" id="district" onchange="districtFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($District as $key=>$val)
                                        <option value="{{$val}}" {{Request::get('District')==$val ? "selected" :''}}>
                                            {{$val}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Branch </label>
                                    <select name="branch_code" id="branch" onchange="branchFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($branches as $key=>$val)
                                        <option value="{{$val->branch_code }}" {{Request::get('branch_code')==$val->
                                            branch_code ? "selected":''}}>{{$val->branch_code}} ({{$val->branch_name}})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input type="submit" value="Filter" name="submit" class="btn btn-primary" style="margin-top:25px;">
                                <input type="submit" value="Export Excel" name="submit" class="btn btn-primary" style="margin-top:25px;">
                            </div>
                        </form>
                    </div>
                </div>
                <br>
            </div>
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th width="5%">S.No.</th>
                                        <th width="8%">Date</th>                                        
                                        <th width="8%">Branch Name</th>                                        
                                        <th width="8%">Branch Code</th>                                        
                                        <th width="10%">In Time</th>
                                        <th width="10%">In message</th>
                                        <th width="10%">Out Time</th>                                        
                                        <th width="10%">Out message</th>                                        
                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($attendances as $key =>$val)
                                    <tr>
                                       
                                        <td>{{ $key+1 }}.</td>
                                        <td>{{ Carbon::parse($val->date)->format('d-M-Y')}}</td>                                        
                                        <td>{{ $val->Branch->branch_name}}</td>                                        
                                        <td>{{ $val->Branch->branch_code}}</td>                                        
                                        <td>{{date("h:i:s A", strtotime($val->in_time))}}</td>
                                        <td>{{$val->message_morning}}</td>
                                        <td>{{isset($val->out_time) ? date("h:i:s A", strtotime($val->out_time)) : ''}}</td>
                                        <td>{{$val->message_night}}</td>                                       
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="8">No Record Found !!</td>
                                    </tr>

                                    @endforelse



                                </tbody>
                            </table>
                           {!!$attendances->links()!!}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>
    </div>
</main>

@endsection