@extends('admin.layouts.master')
@php
$role_id = App\Models\Admin::where('id',Session::get('adminsession')->id)->first();
@endphp
@section('main-content')
@php use Illuminate\Support\Str; @endphp
<style>
    .card-body,
    .card-footer {
        font-size: 20px;
    }

    .card-body.largetext {
        font-size: 34px;
        font-weight: 700;
        padding-bottom: 8px;
        padding-top: 8px;
        text-align: center;
    }

    .btnstyle {
        background-color: #1976d2;
        margin-left: 3px;
        margin-bottom: 20px;
    }

    .btnstylenone {
        /* background-color: #1976d2; */
        margin-left: 3px;
        margin-bottom: 20px;
        color: #1976d2;
    }

    .spantag {
        font-size: 19px;
    }

    .fontSize {
        font-size: 13px;
    }

    /* .card p span svg{
            margin-left: 4px;
            font-size: 19px;

        } */
    .card-title {
        color: #25abe9;
    }

    .attendance {
        border: 1px solid #e1e1e170;
        padding: 15px 20px;
        border-radius: 25px;
        font-size: 14px;
        box-shadow: rgba(0, 0, 0, 0.04) 0px 3px 5px;
    }

    .card-value {
        margin-top: 0px;
    }

    .attendance.color1 h5 {
        color: #3d4b66;
        font-size: 20px;
    }

    .attendance.color1 p {
        color: #565656;
        font-size: 15px;
        margin: 0px;
        line-height: normal;
        display: flex;
        justify-content: space-between;
    }

    .attendance.color1 p span:last-child {
        color: #3d4b66;
        font-size: 16px;
        margin: 0px;
        line-height: 25px;
        width: fit-content;
        display: inline-block;
        font-weight: 600;
    }

    .card-title {
        display: flex;
        justify-content: space-between;
    }

    .card-title img {
        width: 56px;
        opacity: 0.3;
        filter: brightness(1) invert(0.5);
    }

    .sheet-data {
        border: 1px solid #0f3e6e7a;
        box-shadow: rgba(9, 30, 66, 0.25) 0px 1px 1px, rgba(9, 30, 66, 0.13) 0px 0px 1px 1px;
    }

    .custome-table thead th {
        border: 1px solid #808da5
    }

    /* Table CSS */

    .rwd-table {
        color: #333;
        border-radius: 10px;
        overflow: hidden;
        overflow-y: scroll;
    }

    .rwd-table tr:first-child {
        border-top: none;
        background: #428bca;
        color: #fff;
    }

    .rwd-table tr {
        border-top: 1px solid #ddd;
        border-bottom: 1px solid #ddd;
        background-color: #f5f9fc;
    }

    .rwd-table tr:nth-child(odd):not(:first-child) {
        background-color: #ebf3f9;
    }

    .rwd-table th {
        display: none;
    }

    .rwd-table td {
        display: block;
    }

    .rwd-table td:first-child {
        margin-top: .5em;
    }

    .rwd-table td:last-child {
        margin-bottom: .5em;
    }

    .rwd-table td:before {
        content: attr(data-th) ": ";
        font-weight: bold;
        width: 120px;
        display: inline-block;
        color: #000;
    }

    .rwd-table th,
    .rwd-table td {
        text-align: left;
    }

    .rwd-table {
        color: #333;
        border-radius: 10px;
        overflow: hidden;
    }

    .rwd-table tr {
        border-color: #bfbfbf;
    }

    .rwd-table th,
    .rwd-table td {
        padding: .5em 1em;
    }

    @media screen and (max-width: 601px) {
        .rwd-table tr:nth-child(2) {
            border-top: none;
        }
    }

    @media screen and (min-width: 600px) {
        .rwd-table tr:hover:not(:first-child) {
            background-color: #d8e7f3;
        }

        .rwd-table td:before {
            display: none;
        }

        .rwd-table th,
        .rwd-table td {
            display: table-cell;
            padding: .25em .5em;
        }

        .rwd-table th:first-child,
        .rwd-table td:first-child {
            padding-left: 0;
        }

        .rwd-table th:last-child,
        .rwd-table td:last-child {
            padding-right: 0;
        }

        .rwd-table th,
        .rwd-table td {
            padding: 8px !important;
            border: 1px solid #ddd;
        }
    }

    .custom-input-search input[type=date].form-control {
        border: 1px solid #ddd;
        border-radius: 30px;
        padding: 18px 10px;
        line-height: 26px;
    }

    .custom-input-search .btn {
        padding: 10px 20px;
        border-radius: 30px;
        background: linear-gradient(45deg, #3d4b66, #59abff);
        border: none;
        line-height: normal;
        font-size: 14px;
        font-weight: 500;
    }

    .custom-input-search .btn.reset {
        background: linear-gradient(90deg, #ff8b00, #f50000);
    }

    .custom-input-search .btn-primary:focus,
    .btn-primary.focus {
        box-shadow: none
    }

    .justify-content-center {
        justify-content: center
    }

    .dashboard-cardfull-row {
        / flex-wrap: nowrap;/ / webkit-flex-wrap: nowrap;/ overflow-y: hidden;
        / overflow-x: scroll;/ overflow-x: hidden;
        margin: 0px;
        margin-bottom: 25px;
    }

    .dashboard-cardfull-row::-webkit-scrollbar-track {
        -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
        background-color: #F5F5F5;
        cursor: move;
    }

    .dashboard-cardfull-row::-webkit-scrollbar {
        width: 10px;
        height: 8px;
        background-color: #F5F5F5;
        cursor: move;
    }

    .dashboard-cardfull-row::-webkit-scrollbar-thumb {
        background-color: #3d4b66;
        border: 2px solid #555555;
        cursor: move;
    }

    @media screen and (max-width:768px) {
        .dashboard-cardfull-row {
            flex-wrap: wrap;
            webkit-flex-wrap: wrap;
        }

        .dataInTable {
            overflow-y: scroll;
        }
    }
</style>

<main>
    <div class="container-fluid mt-5">

        <div class="main">
            <div class="wrapper1">
                <div class="div1">
                   
                </div>
            </div>
            <div class="row dashboard-cardfull-row">
                <h1>  Welcome to  </h1>
                <div class="col-xl-12 col-md-12">
                    
                    @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',17]])->first() || $role_id->role == 1) 

                    <div class="col-xl-3 col-md-6">

                        <div class="card attendance text-dark  mb-4 color1"
                            style="background-color: #66ccff1c;height: 209px; border: 1px solid #59abff;">
                            <h5 class="card-title"><b>Attendance</b> <img src="{{asset('branch\images\check.png')}}"
                                    alt=""></h5>
                            <div class="card-value">
                                <p class=""><span> Total Present :</span> <span>{{$totalPresent->count()}}</span> </p>
                                <p class=""><span> Total Absent :</span> <span>{{$operators->where('status',
                                        '1')->count()-$totalPresent->count()}}</span> </p>
                            </div>

                        </div>
                    </div>
                    @endif
                    @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',18]])->first() || $role_id->role == 1) 

                    <div class="col-xl-3 col-md-6">

                        <div class="card attendance text-dark  mb-4 color1"
                            style="background-color: #cdac1812; height: 209px; border: 1px solid #cdac18;">
                            <h5 class="card-title"><b>Operators</b> <img src="{{asset('branch\images\operator.png')}}"
                                    alt=""></h5>
                            <div class="card-value">
                                <p class=""><span> Active :</span> <span>{{$operators->where('status',
                                        '1')->count()}}</span> </p>
                                <p class=""><span> Inactive :</span> <span> {{$operators->where('status',
                                        '2')->count()}}</span> </p>
                                <p class=""><span> Disassociated :</span> <span> {{$operators->where('status',
                                        '3')->count()}}</span> </p>
                                <p class=""><span> Blacklisted :</span> <span> {{$operators->where('status',
                                        '0')->count()}}</span> </p>
                            </div>

                        </div>
                    </div>
                    @endif
                    @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',19]])->first() || $role_id->role == 1) 

                    <div class="col-xl-3 col-md-6">

                        <div class="card attendance text-dark  mb-4 color1"
                            style="background-color: #00ff662b; height: 209px; border: 1px solid #138942;">
                            <h5 class="card-title"><b>Enrolment Kits</b> <img
                                    src="{{asset('branch\images\suitcase.png')}}" alt=""></h5>
                            <div class="card-value">
                                <p class=""><span> Active :</span> <span>{{$operators->where('status',
                                        '1')->count()}}</span> </p>
                                <p class=""><span> Inactive :</span> <span> {{$operators->Where('status', '2')->count()
                                        +$operators->Where('status', '3')->count() +$operators->Where('status',
                                        '0')->count()}}</span> </p>
                            </div>

                        </div>
                    </div>
                    @endif
                    @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',20]])->first() || $role_id->role == 1) 

                    <div class="col-xl-3 col-md-6">

                        <div class="card attendance text-dark  mb-4 color1"
                            style="background-color: #66ccff1c; height: 209px;  border: 1px solid #59abff;">
                            <h5 class="card-title"><b>MIS Update: <span style="font-size: 15px; display:block">

                                    </span></b> <img src="{{asset('branch/images/group.png')}}" alt="">
                            </h5>
                            <div class="card-value">
                                <p class=""> ({{date('d-M-Y', strtotime($lastMisDate))}}-{{$formattedTime}})
                                </p>
                                <p class=""><span> Update By Operators : </span>
                                    <span>{{$lastUpdateOperatorsCount}}</span>
                                </p>
                                <a href="{{url('admin/get-not-Operators-mis')}}">
                                    <p class=""><span> Not Update By Operators :</span> <span>
                                            {{$allOperator_Code-$lastUpdateOperatorsCount }}</span> </p>
                                </a>
                            </div>

                        </div>
                    </div>
                    @endif

                    <div class="col-md-12">
                        <div class="row">
                            @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',21]])->first() || $role_id->role == 1) 

                            <div class="col-xl-4 col-md-6">

                                <div class="card attendance text-dark  mb-4 color1"
                                    style="background-color: #66ccff1c;height: 250px; border: 1px solid #59abff;">
                                    <h5 class="card-title"><b>Top 5 Operators (30 days Enrolment Wise)</b> </h5>
                                    <div class="card-value">
                                        <p class=""><span><b>Operator Name</b></span>
                                            <span>Total Enrolments</span>
                                        </p>

                                        @foreach ($enrollmentListTopDailyWise as $key=>$top5DailyWise)

                                        <p class=""><span> {{ ucfirst(strtolower($top5DailyWise['Operator_Name']))
                                                }}</span>
                                            <span> {{$top5DailyWise['number']}}</span>
                                        </p>
                                        @endforeach


                                    </div>

                                </div>
                            </div>
                            @endif
                            @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',22]])->first() || $role_id->role == 1) 

                            <div class="col-xl-4 col-md-6">

                                <div class="card attendance text-dark  mb-4 color1"
                                    style="background-color: #cdac1812; height: 250px; border: 1px solid #cdac18;">
                                    <h5 class="card-title"><b>Top 5 Pending Payments (Operator)</b> </h5>
                                    <div class="card-value">
                                        <p class=""><span><b>Operator Name</b></span>
                                            <span>Pending Payment</span>
                                        </p>

                                        @foreach ($pendingTopPaymentOperator as $key=>$PaymentOperator)

                                        <p class=""><span>{{ ucfirst(strtolower($PaymentOperator['Operator_name'])) }}
                                                :</span>
                                            <span>{{$PaymentOperator['total_pending_amount']}}</span>
                                        </p>
                                        @endforeach


                                    </div>

                                </div>
                            </div>
                            @endif
                            @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',23]])->first() || $role_id->role == 1) 

                            <div class="col-xl-4 col-md-6">

                                <div class="card attendance text-dark  mb-4 color1"
                                    style="background-color: #00ff662b; height: 250px; border: 1px solid #138942;">
                                    <h5 class="card-title"><b>Top 5 Pending Payments (Branch)</b> </h5>
                                    <div class="card-value">
                                        <p class=""><span> <b>Branch Name</b></span>
                                            <span>Pending Payment</span>
                                        </p>

                                        @foreach ($pendingTopPaymentBranch as $key=>$branch)


                                        <p class=""><span>{{
                                                ucfirst(strtolower(App\Models\Branch::where('branch_code',$branch->branch_code)->value('branch_name')))
                                                }} :</span>
                                            <span>{{$branch->pending_amount}}</span>
                                        </p>





                                        @endforeach


                                    </div>

                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                </div>
                <div class="col-xl-12 col-md-12">

                    <div class="row mb-4 ">

                        <div class="col-lg-8" id="filterdataAjax">
                            <div class="row">
                                @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',24]])->first() || $role_id->role == 1) 

                                <div class="col-xl-6 col-md-6">
                                    <div class="card attendance text-dark  mb-4 color1"
                                        style="background-color: #66ccff1c;height: 209px; border: 1px solid #59abff;">
                                        <h5 class="card-title"><b>Total Enrolments Summary </b> </h5>
                                        <div class="card-value">
                                            <p class=""><span> Total Enrolments :</span>
                                                <span>{{$Total_enrollments[0]->number}}</span>
                                            </p>
                                            <p class=""><span> New Enrolments :</span>
                                                <span>{{$new_enrollments[0]->number}}</span>
                                            </p>
                                            <p class=""><span> Mandatory Biometric Update :</span>
                                                <span>{{$mandatory_bio_biometric_update[0]->number}}</span>
                                            </p>
                                            <p class=""><span> Demographic Update :</span>
                                                <span>{{$total_demographic_update[0]->number}}</span>
                                            </p>
                                            <p class=""><span> Biometric Update :</span>
                                                <span>{{$biometric_update[0]->number}}</span>
                                            </p>
                                        </div>

                                    </div>

                                </div>
                                @endif
                                @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',25]])->first() || $role_id->role == 1) 

                                <div class="col-xl-6 col-md-6">
                                    <div class="card attendance  text-dark  mb-4 color1"
                                        style="background-color: #cdac1812; height: 209px; border: 1px solid #cdac18;">
                                        {{-- <p class="ml-2 "><b>Top 5 Operators (Daily Enrolment Wise)</b> </p> --}}
                                        <h5 class="card-title"><b>Total Payment Summary</b> </h5>
                                        <p><span>Total Amount Collected :</span> <span>
                                                {{$Total_enrollments[0]->Total_amount_charged}}</span></p>
                                        <p><span>Demographic Update Amount :
                                            </span> <span>{{$total_demographic_update[0]->Total_amount_charged}}</span>
                                        </p>
                                        <p><span>Biometric Update Amount: </span>
                                            <span>{{$biometric_update[0]->Total_amount_charged}}</span>
                                        </p>
                                        <p><span>Payment Deposited : </span> <span>{{$PaymentDeposited}}</span></p>
                                        <p><span>Payment Pending : </span> <span>{{$PaymentPending}}</span></p>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <!--<div class="row mb-4 custom-input-search justify-content-center">-->
                        <div class="col-lg-4">
                            @if (DB::table('model_has_roles')->where([['role_id',$role_id->role],['model_id',26]])->first() || $role_id->role == 1) 

                            <div class="row">
                                <div class="col-lg-6 col-sm-12">
                                    <div class="mb-3">
                                        <label for="from_date" class="form-label">From Date</label>
                                        <input type="date" class="form-control" id="from_date"
                                            placeholder="Example input placeholder">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <div class="mb-3">
                                        <label for="to_date" class="form-label">To Date</label>
                                        <input type="date" class="form-control" id="to_date"
                                            placeholder="Example input placeholder">
                                    </div>
                                </div>
                                <!--<div class="col-lg-4 col-sm-12">-->
                                <div class="form-group" style="margin: 0.5rem auto;">
                                    <button type="button" onclick="filterData()" class="btn btn-primary">
                                        Search</button>
                                    <button type="button" onclick="reset()" class="btn btn-primary reset">
                                        Reset</button>
                                </div>
                                <!--</div>-->

                            </div>
                            <div id="loadingbutton"></div>
                            <hr>
                            @endif
                            <!--</div>-->
                        </div>
                    </div>

                </div>

            </div>



        </div>
    </div>
</main>
@endsection
@section('javascript')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
    $(document).ready(function () {
        $("#main").click(function () {
            $(".enrollments").css("display", "none");
            $(".main").css("display", "block");
            $("#main").css('backgroundColor', '#1976d2');
            $("#enrollments").css('backgroundColor', '#ffff');
        });


        $("#enrollments").click(function () {
            $("#enrollments").css({ backgroundColor: '#1976d2' });
            $("#main").css('backgroundColor', '#ffff');
            $(".enrollments").css("display", "block");
            $(".main").css("display", "none");
        });
    });



</script>

<script>
    function filterData() {
        // alert('hgvhgvh');
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        // alert(from_date);
        if (from_date != '' && to_date != '') {
            $("#loadingbutton").prepend('<i class="fa fa-spinner fa-spin"></i>');
            //   $('#filterdataAjax').html(ht_data);


            $.ajax({
                type: "post",
                url: "{{route('dashboardAjax')}}",
                data: {
                    'from_date': from_date,
                    "to_date": to_date,
                    "_token": "{{csrf_token()}}"
                },
                success: function (res) {
                    if (res.status == 'success') {
                        // $('#player-container').css('display','none');
                        $('#filterdataAjax').empty();
                        $("#loadingbutton").find(".fa-spinner").remove();
                        $('#filterdataAjax').append(res.data);
                    }
                }
            });
        } else {
            alert('Please select date range.');
        }
    }
    function reset() {
        // alert('hgvhgvh');

        // alert(from_date);

        $("#loadingbutton").prepend('<i class="fa fa-spinner fa-spin"></i>');
        //   $('#filterdataAjax').html(ht_data);


        $.ajax({
            type: "post",
            url: "{{route('dashboardAjax')}}",
            data: {
                'from_date': 'all',
                "to_date": 'all',
                "_token": "{{csrf_token()}}"
            },
            success: function (res) {
                if (res.status == 'success') {
                    // $('#player-container').css('display','none');
                    $('#filterdataAjax').empty();
                    $("#loadingbutton").find(".fa-spinner").remove();
                    $('#filterdataAjax').append(res.data);
                }
            }
        });

    }
</script>
<script>
    const slider = document.querySelector('.dashboard-cardfull-row');
let isDown = false;
let startX;
let scrollLeft;

slider.addEventListener('mousedown', (e) => {
  isDown = true;
  slider.classList.add('active');
  startX = e.pageX - slider.offsetLeft;
  scrollLeft = slider.scrollLeft;
});
slider.addEventListener('mouseleave', () => {
  isDown = false;
  slider.classList.remove('active');
});
slider.addEventListener('mouseup', () => {
  isDown = false;
  slider.classList.remove('active');
});
slider.addEventListener('mousemove', (e) => {
  if(!isDown) return;
  e.preventDefault();
  const x = e.pageX - slider.offsetLeft;
  const walk = (x - startX) * 1; //scroll-fast
  slider.scrollLeft = scrollLeft - walk;
  console.log(walk);
});
</script>
@endsection