@extends('admin.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Enrollment client list serial no</h2>

        <div class="row">

            <div class="card-body">
                <form  method="get">
                    <div class="col-md-2">
                        <label for="">From Date</label>
                        <input type="date" name="from_date" value="{{Request::get('from_date')}}" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label for="">To Date</label>
                        <input type="date" name="to_date" value="{{Request::get('to_date')}}" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label for="">Registrar EA Combination</label>
                        <select name="registrarscode" id="eacode" onchange="eacodeFun()" class="form-control">
                            <option value="">All</option>
                            @foreach(DB::table('registrars')->get() as $key=>$val)
                            <option value="{{$val->Ea_Code}}" {{Request::get('registrarscode')==$val->Ea_Code ? 'selected':''}}>{{$val->Ea_Code}} ({{$val->Ea_Name}})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">State</label>
                        <select name="state" id="state" onchange="stateFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($state as $key=>$val)
                            <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label for="">District</label>
                        <select name="district" id="district" onchange="districtFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($districtData as $key=>$val)
                            <option value="{{$val->District}}" {{Request::get('district')==$val->
                                District?'selected':''}}>{{$val->District}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">Branch</label>
                        <select name="branch" id="branch" onchange="branchFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($branchData as $key=>$val)
                            <option value="{{$val->branch_code}}" {{Request::get('branch')==$val->
                                branch_code?'selected':''}}>{{$val->branch_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">Operator</label>
                        <select name="operator" id="operator" class="js-example-basic-single form-control"
                            style="width: 100%;">
                            <option value="">All</option>

                            @foreach($operatorData as $key=>$val)
                            <option value="{{$val->Operator_Code}}" {{Request::get('operator')==$val->
                                Operator_Code?'selected':''}}>{{$val->Operator_Code .' ('. $val->Operator_Name.')'}}
                            </option>
                            @endforeach
                        </select>
                    </div>


                    <div class="col-md-2">
                        <label for=""></label>
                        <input type="submit" value="Search" class="btn btn-primary" style="margin-top: 25px;">
                        <input type="submit" name="submit" class="btn btn-primary" value="Export Excel"  style="margin-top: 25px; float:right;">
                    </div>

                </form>
            </div>

            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        {{-- <h6 class="card-title"></h6> --}}
                        {{-- <button class="btn btn-primary"><i class="fa fa-download"></i>enrollment client serial missing</button> --}}

                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" style="width: 2000px;" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Missing serial number</th>
                                        <th>Operator Code</th>
                                        <th>Operator Name</th>
                                        <th>Branch Name</th>
                                        <th>Branch Code </th>
                                        <th>District</th>
                                        <th>State</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @forelse ($enrollmentList as $key =>$val)
                                    <tr>
                                        <td>{{ $key+ $enrollmentList->firstItem() }}.</td>
                                        <td>
                                            @foreach (json_decode($val->missing_serial_no) as $key)
                                                {{$key}},
                                        @endforeach
                                    </td>
                                        <td>{{$val->operator_code}}</td>
                                        <td>{{$val->Operator->Operator_Name}}</td>
                                        <td>{{$val->branch_code}}</td>
                                        <td>{{$val->Branch->branch_name}}</td>
                                        <td>{{$val->Operator->District}}</td>
                                        <td>{{$val->Operator->State}}</td>
                                        <td>{{date('d-m-Y', strtotime($val->created_at))}}</td>
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="8">No Record Found !!</td>
                                    </tr>

                                    @endforelse


                                </tbody>
                            </table>
                            @if(!empty($enrollmentList)) {!!$enrollmentList->appends($_GET)->links()!!} @endif
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

@endsection
