@extends('admin.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Enrollment Client List</h2>

        <div class="row">

            <div class="card-body">
                <form action="{{url('admin/enrollment-client-view')}}" method="get">
                    <div class="col-md-2">
                        <label for="">From Date</label>
                        <input type="date" name="from_date" value="{{Request::get('from_date')}}" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label for="">To Date</label>
                        <input type="date" name="to_date" value="{{Request::get('to_date')}}" class="form-control" required>
                    </div>
                    <div class="col-md-2">
                        <label for="">Registrar EA Combination</label>
                        <select name="registrarscode" id="eacode" onchange="eacodeFun()" class="form-control">
                            <option value="">All</option>
                            @foreach(DB::table('registrars')->get() as $key=>$val)
                            <option value="{{$val->Ea_Code}}" {{Request::get('registrarscode')==$val->Ea_Code ? 'selected':''}}>{{$val->Ea_Code}} ({{$val->Ea_Name}})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">State</label>
                        <select name="state" id="state" onchange="stateFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($state as $key=>$val)
                            <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="col-md-2">
                        <label for="">District</label>
                        <select name="district" id="district" onchange="districtFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($districtData as $key=>$val)
                            <option value="{{$val->District}}" {{Request::get('district')==$val->
                                District?'selected':''}}>{{$val->District}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">Branch</label>
                        <select name="branch" id="branch" onchange="branchFun()" class="form-control">
                            <option value="">All</option>
                            @foreach($branchData as $key=>$val)
                            <option value="{{$val->branch_code}}" {{Request::get('branch')==$val->
                                branch_code?'selected':''}}>{{$val->branch_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="">Operator</label>
                        <select name="operator" id="operator" class="js-example-basic-single form-control"
                            style="width: 100%;">
                            <option value="">All</option>

                            @foreach($operatorData as $key=>$val)
                            <option value="{{$val->Operator_Code}}" {{Request::get('operator')==$val->
                                Operator_Code?'selected':''}}>{{$val->Operator_Code .' ('. $val->Operator_Name.')'}}
                            </option>
                            @endforeach
                        </select>
                    </div>
                   

                    <div class="col-md-2">
                        <label for=""></label>
                        <input type="submit" value="Search" class="btn btn-primary" style="margin-top: 25px;">
                    </div>

                </form>
            </div>

            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" style="width: 2000px;" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Enrolment No. And Date</th>
                                        <th>Appointment Id</th>
                                        <th>Type</th>
                                        <th>Mandatory Biometric Update</th>
                                        <th>IS_NRI</th>
                                        <th>Tin Number </th>
                                        <th>Operator ID </th>
                                        <th>Reviewer ID </th>
                                        <th>Introducer</th>
                                        <th>Proof</th>
                                        <th>Resident</th>
                                        <th>Status</th>
                                        <th>Introducer Review Status </th>
                                        <th>User Review Status </th>
                                        <th>GST Applied(%) </th>
                                        <th>Amount Charged For New Enrolment </th>
                                        <th>Amount Charged For Update Enrolment </th>
                                        <th>Total Amount Charged</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @forelse ($enrollmentList as $key =>$val)
                                    <tr>
                                        <td>{{ $key+ $enrollmentList->firstItem() }}.</td>
                                        <td>{{$val->Enrolment_No_and_Date}}</td>
                                        <td>{{$val->Appointment_Id}}</td>
                                        <td>{{$val->Type}}</td>
                                        <td>{{$val->Mandatory_biometric_update}}</td>
                                        <td>{{$val->IS_NRI}}</td>
                                        <td>{{$val->Tin_Number}}</td>
                                        <td>{{$val->Operator_ID}}</td>
                                        <td>{{$val->Reviewer_ID}}</td>
                                        <td>{{$val->Introducer}}</td>
                                        <td>{{$val->Proof}}</td>
                                        <td>{{$val->Resident}}</td>
                                        <td>{{$val->Status}}</td>
                                        <td>{{$val->Introducer_Review_Status}}</td>
                                        <td>{{$val->User_Review_Status}}</td>
                                        <td>{{$val->GSApplied_Percentage}}</td>
                                        <td>{{$val->Amount_charged_for_New_Enrolment}}</td>
                                        <td>{{$val->Amount_charged_for_Update_Enrolment}}</td>
                                        <td>{{$val->Total_amount_charged}}</td>
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="19">No Record Found !!</td>
                                    </tr>

                                    @endforelse


                                </tbody>
                            </table>
                            @if(!empty($enrollmentList)) {!!$enrollmentList->appends($_GET)->links()!!} @endif
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

@endsection
