@extends('admin.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">Operator Report</h2>
           <form action="{{url('/admin/report')}}" method="get">
            @csrf
            <div class="row">
            <div class="col-md-3">
                    <div class="form-group">
                        <label for="">From Date</label>
                        <input type="date" class="form-control" name="from_date" value="{{Request::get('from_date')}}">
                    </div>
            </div>
               <div class="col-md-3">
                <div class="form-group">
                            <label for="">To Date</label>
                            <input type="date" name="to_date" class="form-control" value="{{Request::get('to_date')}}">
                        </div>
                 </div>
                 <div class="col-md-3">
                    <div class="form-group">
                        <label for="">Operator Code</label>
                        <input type="text" name="operator_code" class="form-control" value="{{Request::get('operator_code')}}" required>
                    </div>
                 </div>
                 <div class="col-md-3">
                    <div class="form-group">
                        <input type="submit" class="btn btn-primary" value="Search" style="margin-top:25px;">
                    </div>
                 </div>
               
            </div>
            </form>
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title">
                                Report
                            </h6>
                          
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                        <tr>
                                            <th>State</th>
                                            <th></th>
                                            <th>District</th>
                                            <th></th>
                                            <th>Branch ID</th>
                                            <th></th>
                                        </tr>
                                        <tr>
                                            <th>Operator ID</th>
                                            <th>Operator Name</th>
                                            <th>Station Code</th>
                                            <th colspan="2">Registrar Code</th>
                                            <th>EA Code</th>
                                        </tr>
                                        <tr>
                                            <th>{{!empty($data)?$data['Operator_ID']:''}}</th>
                                            <th>{{!empty($data)?$data['Operator_Name']:''}}</th>
                                            <th>{{!empty($data)?$data['Station_Code']:''}}</th>
                                            <th colspan="2">{{!empty($data)?$data['Registrar_Code']:''}}</th>
                                            <th>{{!empty($data)?$data['EA_Code']:''}}</th>
                                        </tr>
                                        <tr>
                                            <th colspan="6"></th>
                                        </tr>
                                        <tr>
                                            <th>New Enrolments</th>
                                            <th>Mandatory Biometric Updates</th>
                                            <th>Demographic Update</th>
                                            <th colspan="3">Biometric Update</th>
                                            <!-- <th>Demographic with Biometric Update</th> -->
                                        </tr>
                                        <tr>
                                            <th>{{!empty($data)?$data['New_Enrolment']:''}}</th>
                                            <th>{{!empty($data)?$data['Mandatory_Biometric_Updates']:''}}</th>
                                            <th>{{!empty($data)?$data['Demographic_Update']:''}}</th>
                                            <th colspan="3">{{!empty($data)?$data['Biometric_Update']:''}}</th>
                                            <!-- <th>{{!empty($data)?$data['Demographic_with_Biometric_Update']:''}}</th> -->
                                        </tr>
                                        <tr >
                                            <th rowspan="7" colspan="2"></th>
                                            <th>Amount Collected (A)</th>
                                            <th colspan="2">Amount Collected (B)</th>
                                            <th>Amount Collected (C)</th>
                                        </tr>
                                        <tr>
                                            <th>{{!empty($data)?$data['AmountCollected_A']:''}}</th>
                                            <th colspan="2">{{!empty($data)?$data['AmountCollected_B']:''}}</th>
                                            <th>{{!empty($data)?$data['AmountCollected_C']:''}}</th>
                                        </tr>
                                        <tr>
                                            <th colspan="3">Total Amount(X)</th>
                                            <th>{{!empty($data)?$data['Total_Amount_X']:''}}</th>
                                        </tr>
                                        <tr>
                                            <th colspan="4"></th>
                                        </tr>
                                        <tr>
                                            <th colspan="3">Total Amount (Y)</th>
                                            <th>= Bank Amt.</th>
                                        </tr>
                                        <tr>
                                            <th colspan="3">PENDANCY</th>
                                            <th>=X-Y</th>
                                        </tr>
                                        <tr>
                                            <th></th>
                                            <th colspan="2"></th>
                                            <th></th>
                                        </tr>
                                       
                                    </thead>
                                    
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>
@endsection
