@extends('admin.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">Branch Due Report</h2>

            <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">

                    </div>
                    <div class="responsive">
                    <form action="{{url('/admin/report/branch-dues-report')}}" method="get">
                        <div class="card-body" id="demo">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">From Date</label>
                                    <input type="date" class="form-control" name="from_date" id="from_date" value="{{Request::get('from_date')}}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">To Date</label>
                                    <input type="date" class="form-control" name="to_date" id="to_date" value="{{Request::get('to_date')}}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Registrar EA Combination</label>
                                    <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach (DB::table('registrars')->get() as $key => $val)
                                        <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                            'selected' : '' }}>
                                            {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label for="">State</label>
                                <select name="state" id="state" onchange="stateFun()" class="form-control">
                                    <option value="">All</option>
                                    @foreach($state as $key=>$val)
                                    <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">District</label>
                                    <select name="district" id="district" onchange="districtFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($districtList as $key=>$val)
                                         <option value="{{$val->District}}" {{Request::get('district') == $val->District ? 'selected':''}}>{{$val->District}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Branch Code</label>
                                    <select name="branch_code" id="branch" onchange="branchFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($branchDropdown as $key=>$val)
                                        <option value="{{$val->branch_code}}" {{Request::get('branch_code') == $val->branch_code ? 'selected':''}}>{{$val->branch_code}} {{$val->branch_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Operator Name</label>
                                    <select name="operator_code" id="operator" class="form-control">
                                        <option value="">All</option>
                                        @foreach($operatorList as $key=>$val)
                                        <option value="{{$val->Operator_Code}}" {{Request::get('operator_code') == $val->Operator_Code ? 'selected':''}}>{{$val->Operator_Code}} {{$val->Operator_Name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input type="submit" class="btn btn-primary" value="Filter" style="margin-top: 25px;">
                            </div>
                        </div>
                    </form>
                    </div>
                </div>
                <br>
            </div>
                <div class="col-md-12">

                    <div class="card card-primary">
                        <div class="card-header">
                            <!-- <h6 class="card-title"></h6> -->
                            <a onclick="excelDownload()" class="btn btn-primary"><i class="fa fa-download"></i> Branch Due Report</a>
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th width="5%">S.No.</th>
                                            <th width="8%">Branch Name</th>
                                            <th width="12%">District</th>
                                            <th width="20%">Operator ID</th>
                                            <th width="10%">Operator Name</th>
                                            <th width="10%">Station Code</th>
                                            <th width="10%">Total No of Enrollment	</th>
                                            <th width="10%">Total No of update	</th>
                                            <th width="10%">New Enrolments	</th>
                                            <th width="10%">Demographic Updates	</th>
                                            <th width="10%">Mandatory Biometric Updates(5/15 years)	</th>
                                            <th width="10%">Biometric Updates	</th>
                                            <th width="10%">Total Amount Collected Towards Demographic Updates.	</th>
                                            <th width="10%">Total Amount Collected Towards Biometric Updates	</th>
                                            <th>Total payment collected by Operators</th>
                                            <th>Total payment Deposited by Operators / Branch</th>
                                            <th>Dues on Operator / Branch</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @forelse ($enrollmentList as $key =>$val)
                                        <tr>
                                            <td>{{ $key+$branchList->firstItem() }}.</td>
                                            <td>{{$val['branch_name']}}</td>
                                            <td>{{$val['district']}}</td>
                                            <td>{{$val['Operator_Code']}}</td>
                                            <td>{{$val['Operator_Name']}}</td>
                                            <td>{{$val['Station_Code']}}</td>
                                            <td>{{$val['total_No_of_Enrollment']}}</td>
                                            <td>{{$val['total_no_of_update']}}</td>
                                            <td>{{$val['new_enrollments']}}</td>
                                            <td>{{$val['total_demographic_update']}}</td>
                                            <td>{{$val['mandatory_bio_biometric_update']}}</td>
                                            <td>{{$val['biometric_update']}}</td>
                                            <td>{{$val['total_amount_collected_A']}}</td>
                                            <td>{{$val['total_amount_collected_B']}}</td>
                                            <td>{{$val['total_collect_amount']}}</td>
                                            <td>{{$val['total_deposit_bank']}}</td>
                                            <td>{{($val['total_pending_amount'])}}</td>

                                        </tr>
                                        @empty

                                        <tr>
                                            <td colspan="19">No Record Found !!</td>
                                        </tr>

                                        @endforelse


                                    </tbody>
                                </table>
                                {!!$branchList->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>
@endsection
 <!-- Include jQuery -->
 <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        function excelDownload(){
            var from_date     = $('#from_date').val();
            var to_date       = $('#to_date').val();
            var operator_code = $('#operator').val();
            var branch_code   = $('#branch').val();
            var district      = $('#district').val();
            var eacode      = $('#eacode').val();
            var state      = $('#state').val();

            window.location.href="{{url('/admin/get-excel-branch-due')}}?from_date="+from_date+"&to_date="+to_date+"&operator_code="+operator_code+"&branch_code="+branch_code+"&district="+district+"&eacode="+eacode+"&state="+state;

        }
    </script>
