@extends('admin.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">Salary Reporting List</h2>

            <div class="row">
            <div class="col-md-12">
            <div class="card card-primary">
                        <div class="card-header">
                            <!-- <h6 class="card-title"></h6> -->
                            <a href="{{url('/admin/salary-calculate')}}"  style="float: right;"><button class="btn btn-primary">Generate Salary</button></a>
                        </div>
                        <form action="{{url('/admin/report/salary-report')}}" method="get">
                        <div class="card-body" id="demo">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">From Date</label>
                                    <input type="date" class="form-control" name="from_date" id="from_date" value="{{Request::get('from_date')}}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">To Date</label>
                                    <input type="date" class="form-control" name="to_date" id="to_date" value="{{Request::get('to_date')}}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Registrar EA Combination</label>
                                    <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach (DB::table('registrars')->get() as $key => $val)
                                        <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                            'selected' : '' }}>
                                            {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label for="">State</label>
                                <select name="state" id="state" onchange="stateFun()" class="form-control">
                                    <option value="">All</option>
                                    @foreach($state as $key=>$val)
                                    <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">District</label>
                                    <select name="district" id="district" onchange="districtFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($districtList as $key=>$val)
                                         <option value="{{$val->District}}" {{Request::get('district') == $val->District ? 'selected':''}}>{{$val->District}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Branch Code</label>
                                    <select name="branch_code" id="branch" onchange="branchFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($branchList as $key=>$val)
                                        <option value="{{$val->branch_code}}" {{Request::get('branch_code') == $val->branch_code ? 'selected':''}}>{{$val->branch_code}} {{$val->branch_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="">Operator Name</label>
                                    <select name="operator_code" id="operator" class="form-control">
                                        <option value="">All</option>
                                        @foreach($operatorList as $key=>$val)
                                        <option value="{{$val->Operator_Code}}" {{Request::get('operator_code') == $val->Operator_Code ? 'selected':''}}>{{$val->Operator_Code}} {{$val->Operator_Name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input type="submit" name="submit" class="btn btn-primary" value="Filter" style="margin-top: 25px;">
                                <input type="submit" name="submit" class="btn btn-primary" value="Export Excel"  style="margin-top: 25px; float:right;">
                            </div>
                        </div>
                        </form>
                </div>
            </div>
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <!-- <h6 class="card-title"></h6> -->
                            
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" style="width: 2000px;" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Branch</th>
                                            <th>District</th>
                                            <th>Operator ID</th>
                                            <th>Operator/Supervisor Name </th>
                                            <th>Father Name</th>
                                            <th>Date Of Joining</th>
                                            <th>Salary Date</th>
                                            <th>Total Present days in month</th>
                                            <th>Total Full Day</th>
                                            <th>Total Half Day</th>
                                            <th>Payout@11098	</th>
                                            <th>ESIC @.75%</th>
                                            <th>PF @12%</th>
                                            <th>Employer ESIC @ 3.25%</th>
                                            <th>Employer PF @ 13%</th>
                                            <th>TOTAL</th>
                                            <th>Net Salary	</th>
                                            <th>PF NO.	</th>
                                            <th>ESI NO	</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                        @forelse ($List as $key =>$val)
                                        <tr>
                                            <td>{{$key + $List->firstItem()}}</td>
                                            <td>{{$val->branch->branch_name}}</td>
                                            <td>{{$val->branch->district}}</td>
                                            <td>{{$val->operator_code}}</td>
                                            <td>{{$val->operator->Operator_Name}}</td>
                                            <td>{{$val->operator->Father_Name}}</td>
                                            <td>{{date('d-m-Y', strtotime($val->created_at))}}</td>
                                            <td>{{$val->salary_date}}</td>
                                            <td>{{$val->total_present_in_month}}</td>
                                            <td>{{$val->total_fullday_count}}</td>
                                            <td>{{$val->total_halfday_count}}</td>
                                            <td>{{$val->payout}}</td>
                                            <td>{{$val->ESIC}}</td>
                                            <td>{{$val->PF}}</td>
                                            <td>{{$val->Employer_ESIC}}</td>
                                            <td>{{$val->Employer_PF}}</td>
                                            <td>{{$val->TOTAL}}</td>
                                            <td>{{$val->Net_Salary}}</td>
                                            <td>{{$val->PF_NO}}</td>
                                            <td>{{$val->ESI_NO}}</td>
                                        </tr>
                                        @empty

                                        <tr>
                                            <td colspan="17">No Record Found !!</td>
                                        </tr>
                                            
                                        @endforelse
                                     
                                        
                                    </tbody>
                                </table>
                                {!!$List->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>
@endsection
