@extends('admin.layouts.master')
@section('main-content')
<main>

    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Total EID List</h2>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">

                    </div>
                    <div class="responsive">
                        <form action="{{url('/admin/report/total-eid-list')}}" method="get">
                            <div class="card-body" id="demo">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">From Date</label>
                                        <input type="date" required class="form-control" name="from_date" id="from_date"
                                            value="{{Request::get('from_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">To Date</label>
                                        <input type="date" required class="form-control" name="to_date" id="to_date"
                                            value="{{Request::get('to_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Registrar EA Combination</label>
                                        <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                            <option value="">All</option>
                                            @foreach (DB::table('registrars')->get() as $key => $val)
                                            <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->
                                                Ea_Code ?
                                                'selected' : '' }}>
                                                {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label for="">State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($state as $key=>$val)
                                        <option value="{{$val->state}}" {{Request::get('state')==$val->state ?
                                            'selected':''}}>{{$val->state}}</option>
                                        @endforeach
                                    </select>
                                </div>
                               
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">District</label>
                                        <select name="district" id="district" onchange="districtFun()" class="form-control">
                                            <option value="">All</option>
                                            @foreach($districtList as $key=>$val)
                                            <option value="{{$val->District}}" {{Request::get('district')==$val->
                                                District ? 'selected':''}}>{{$val->District}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">Branch Code</label>
                                        <select name="branch_code" id="branch" onchange="branchFun()" class="form-control">
                                            <option value="">All</option>
                                            @foreach($branchDropdown as $key=>$val)
                                            <option value="{{$val->branch_code}}" {{Request::get('branch_code')==$val->
                                                branch_code ? 'selected':''}}>{{$val->branch_code}}
                                                {{$val->branch_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">Operator Name</label>
                                        <select name="operator_code" id="operator" class="form-control">
                                            <option value="">All</option>
                                            @foreach($operatorList as $key=>$val)
                                            <option value="{{$val->Operator_Code}}"
                                                {{Request::get('operator_code')==$val->Operator_Code ?
                                                'selected':''}}>{{$val->Operator_Code}} {{$val->Operator_Name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <input type="submit" class="btn btn-primary" value="Filter"
                                        style="margin-top: 25px;">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <br>
            </div>
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <!-- <h6 class="card-title"></h6> -->
                        <a onclick="excelDownload()" class="btn btn-primary"><i class="fa fa-download"></i> EID
                            Report</a>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th width="5%">S.No.</th>
                                        <th width="8%">Branch</th>
                                        <th width="12%">District</th>
                                        <th width="20%">Operator ID</th>
                                        <th width="10%">Operator Name</th>
                                        <th width="10%">Station Code</th>
                                        <th width="10%">Date of Enrolment</th>

                                        <th width="10%">EID of Enrolment </th>
                                        <th>Type of Enrolment </th>
                                        <th>Resident Name </th>
                                        <th>Charged Amount</th>

                                    </tr>
                                </thead>
                                <tbody>


                                    @forelse ($enrollmentList as $key =>$val)
                                    <tr>
                                        <td>{{ $key+$enrollmentList->firstItem() }}.</td>
                                        <td>{{$val->branch_name}}</td>
                                        <td>{{$val->district}}</td>
                                        <td>{{$val->Operator_ID}}</td>
                                        <td>{{$val->Operator_Name}}</td>
                                        <td>{{$val->Station_ID}}</td>
                                        <td>{{date('d-m-Y', strtotime($val->c_date))}}</td>
                                        <td>{{$val->Enrolment_No_and_Date}}</td>
                                        <td>{{$val->Type}}</td>
                                        <td>{{$val->Resident}}</td>
                                        <td>{{$val->Total_amount_charged}}</td>
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="19">No Record Found !!</td>
                                    </tr>

                                    @endforelse


                                </tbody>
                            </table>
                            {!!$enrollmentList->appends($_GET)->links()!!}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>
@endsection
<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    function excelDownload(){
            var branch_code   = $('#branch').val();
            var district      = $('#district').val();
            var eacode      = $('#eacode').val();
            var operator_code = $('#operator').val();
            var state = $('#state').val();
            var from_date     = $('#from_date').val();
            var to_date       = $('#to_date').val();
            
            window.location.href="{{url('/admin/get-excel-eid')}}?from_date="+from_date+"&to_date="+to_date+"&branch_code="+branch_code+"&district="+district+"&operator_code="+operator_code+"&eacode="+eacode+"&state="+state;
           }
</script>
