@extends('admin.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Add Role</h2>

            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                        </div>
                        <div class="card-body" id="demo">


                            <form action="{{route('admin.role_has_permissions.role')}}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <label for="name">Role Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{old('name')}}" placeholder="Enter a Role Name">
                                </div>

                                <div class="form-group">
                                    <label for="name">Permissions</label>

                                    <div class="form-check">
                                        <input type="checkbox" onclick="allCheckBoc()" class="form-check-input" id="checkPermissionAll" value="1">
                                        <label class="form-check-label"  for="checkPermissionAll">All</label>
                                    </div>
                                    <hr>
                                    @php $i = 1; @endphp
                                    @foreach ($permission_groups as $group)
                                        <div class="row">
                                            <div class="col-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" name="Parent_{{ $group->id}}[]" id="checkPermissionParent_{{ $group->id }}" value="{{ $group->model_name}}" onclick="parentIDSET({{$group->id}})">
                                                    <label class="form-check-label" for="checkPermission">{{ $group->model_name	 }}</label>
                                                </div>
                                            </div>

                                            <div class="col-9 role-{{ $group->id }}-management-checkbox">
                                                @php  $j=1; @endphp
                                                @foreach ($group->SubModel as $permission)
                                                    <div class="form-check">
                                                        <input type="checkbox" onclick="childIDSET({{$group->id}})" class="form-check-input checkPermission_{{ $group->id }}" name="permissions_{{ $group->id}}[]" id="checkPermission_{{ $group->id }}" value="{{ $permission->id }}">
                                                        <label class="form-check-label" for="checkPermission{{ $permission->id }}">{{ $permission->model_name	 }}</label>
                                                    </div>
                                                    @php  $j++; @endphp
                                                @endforeach
                                                <br>
                                            </div>

                                        </div>
                                        @php  $i++; @endphp
                                    @endforeach


                                </div>


                                <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Save Role</button>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

    </div>
</main>

@endsection


<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
    function parentIDSET(id){
    // alert(id);

   var checkBox = $('#checkPermissionParent_' + id).is(":checked");
   if(checkBox == true){
    $(".checkPermission_" + id).prop("checked", true);
   }else{
    $(".checkPermission_" + id).prop("checked",false);
   }

}

function childIDSET(id){
    // alert(id);
    $("#checkPermissionParent_" + id).prop("checked", true);
}

function allCheckBoc(){
    // alert(id);
    var checkBox = $('#checkPermissionAll').is(":checked");
    if(checkBox == true){
        $("input[type='checkbox']").prop("checked", true);
   }else{
   
    $("input[type='checkbox']").prop("checked", false);
   }

}
</script>
