@extends('admin.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Add User</h2>

  
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                        </div>
                        <div class="card-body" id="demo">
                            <form id="ChangePassForm" action="{{route('admin.role_has_permissions.user.role')}}" method="post">
                                @csrf
                            <div class="row">
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="user_name">User Name</label>
                                        <input type="text" class="form-control" name="user_name" id="user_name"
                                            value="{{old('user_name')}}">
                                    </div>
                                    @error('user_name')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">User Role</label>
                                        <select name="role" id="role" required
                                            class="js-example-basic-single form-control" style="width: 100%;">
                                            <option value="" disabled selected>select role</option>

                                            @foreach($roles as $key=>$val)
                                            <option value="{{$val->id}}" {{Request::get('role')==$val->
                                                id?'selected':''}}>{{$val->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('role')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName"> Contact Number</label>
                                        <input type="number" class="form-control" name="contact_number" id="name"
                                            value="{{old('contact_number')}}">
                                    </div>
                                    @error('contact_number')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">Email ID</label>
                                        <input type="email" class="form-control" name="email" id="email"
                                            value="{{!empty($singleData)? $singleData->email:old('email')}}">
                                    </div>
                                    @error('email')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror

                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">Address</label>
                                        <input type="text" class="form-control" name="address" id="email"
                                            value="{{old('address')}}">
                                    </div>
                                    @error('address')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror

                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">Password</label>
                                        <input type="password" id="myInput" class="form-control" name="password"
                                            id="password" value="{{old('password')}}">

                                        <input type="checkbox" onclick="myFunction()" style="margin-top: 5px;;"> Show
                                        Password
                                    </div>
                                    @error('password')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror

                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">Confirm Password</label>
                                        <input type="password" class="form-control" name="confirm_password"
                                            id="confirm_password" onkeypress="ConPass()"
                                            value="{{old('confirm_password')}}">
                                    </div>

                                    @error('confirm_password')
                                    <p style="color: red">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="inputName">&nbsp;</label>
                                        <div class="clear"></div>
                                        <input type="Submit" value="Submit" class="btn btn-success"
                                            onclick="Validation()">
                                    </div>

                                </div>
                            </div>
                        </form>

                            <div class="card-body" id="demo">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th width="5%">S.No.</th>
                                                <th width="8%">User Name</th>
                                                <th width="8%">User phone no</th>
                                                <th width="8%">Role Name</th>
                                                <th width="8%">email</th>
                                                <th width="8%">password</th>
                                                <th width="12%">Address</th>
                                                <th width="12%">create date</th>
                                                <th width="12%">Action</th>

                                            </tr>
                                        </thead>
                                        <tbody>


                                            @forelse ($admins as $key =>$val)
                                            @if ($val->role != 1)
                                                
                                           
                                            <tr>

                                                <td>{{$key}}</td>
                                                <td>{{$val->name}}</td>
                                                <td>{{$val->phone_no}}</td>
                                                <td>{{App\Models\Role::where('id',$val->role)->value('name') ?? 'Supar
                                                    Admin'}}</td>
                                                <td>{{$val->email}}</td>
                                                <td>{{$val->view_password}}</td>
                                                <td>{{$val->address}}</td>
                                                <td>{{$val->created_at}}</td>
                                                <td>
                                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                                        data-target="#staticBackdrop{{$key}}">
                                                        edit
                                                    </button>
                                                    {{-- <a
                                                        href="{{route('admin.role_has_permissions.view',[$val->id])}}">edit</a>
                                                </td> --}}
                                            </tr>
                                            @endif
                                            <!-- Vertically centered modal -->
                                            <!-- Modal -->
                                            <div class="modal fade" id="staticBackdrop{{$key}}" data-backdrop="static"
                                                data-keyboard="false" tabindex="-1"
                                                aria-labelledby="staticBackdropLabel{{$key}}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="staticBackdropLabel">Update user
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form id="ChangePassForm" action="{{route('admin.role_has_permissions.user.role.update')}}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="id" value="{{$val->id}}">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="user_name">User Name</label>
                                                                        <input type="text" class="form-control" name="user_name" id="user_name"
                                                                            value="{{$val->name}}" required>
                                                                    </div>
                                                                    @error('user_name')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                                                </div>
                                
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">User Role</label>
                                                                        <select name="role" id="role" required
                                                                            class="js-example-basic-single form-control" style="width: 100%;">
                                                                            <option value="" disabled selected>select role</option>
                                
                                                                            @foreach($roles as $key=>$valt)
                                                                            <option value="{{$valt->id}}" {{$val->role==$valt->id?'selected':''}}>{{$valt->name }}
                                                                            </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                    @error('role')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                                                </div>
                                
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName"> Contact Number</label>
                                                                        <input type="number" class="form-control" name="contact_number" id="name"
                                                                            value="{{$val->phone_no}}" required>
                                                                    </div>
                                                                    @error('contact_number')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">Email ID</label>
                                                                        <input type="email" class="form-control" name="email" id="email"
                                                                            value="{{$val->email}}" required>
                                                                    </div>
                                                                    @error('email')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">Address</label>
                                                                        <input type="text" class="form-control" name="address" id="email"
                                                                            value="{{$val->address}}" required>
                                                                    </div>
                                                                    @error('address')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">Password</label>
                                                                        <input type="password" id="myInput" class="form-control" name="password"
                                                                            id="password" value="">
                                
                                                                        <input type="checkbox" onclick="myFunction()" style="margin-top: 5px;;"> Show
                                                                        Password
                                                                    </div>
                                                                    @error('password')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                
                                                                </div>
                                
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">Confirm Password</label>
                                                                        <input type="password" class="form-control" name="confirm_password"
                                                                            id="confirm_password" onkeypress="ConPass()"
                                                                            value="{{old('confirm_password')}}">
                                                                    </div>
                                
                                                                    @error('confirm_password')
                                                                    <p style="color: red">{{ $message }}</p>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="inputName">&nbsp;</label>
                                                                        <div class="clear"></div>
                                                                        <input type="Submit" value="Submit" class="btn btn-success"
                                                                            onclick="Validation()">
                                                                    </div>
                                
                                                                </div>
                                                           
                                                        </form>

                                                        </div>
                                                        {{-- <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">Close</button>
                                                            <button type="button"
                                                                class="btn btn-primary">Understood</button>
                                                        </div> --}}
                                                    </div>
                                                </div>
                                            </div>
                                            @empty

                                            <tr>
                                                <td colspan="19">No Record Found !!</td>
                                            </tr>

                                            @endforelse


                                        </tbody>
                                    </table>

                                </div>

                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>
    </div>
</main>

@endsection
<script>
    function myFunction() {
  var x = document.getElementById("myInput");
  if (x.type === "password") {
    x.type = "text";
  } else {
    x.type = "password";
  }
}
</script>