@extends('admin.layouts.master')

@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Role List</h2>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title">Role</h6>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th width="5%">S.No.</th>
                                        <th width="8%">Role Name</th>
                                        <th width="12%">Role create</th>
                                        <th width="12%">Action</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>


                                    @forelse ($role as $key =>$val)
                                    <tr>
                                       
                                        <td>{{$key+1}}</td>
                                        <td>{{$val->name}}</td>
                                        <td>{{$val->guard_name}}</td>
                                        <td><a href="{{route('admin.role_has_permissions.view',[$val->id])}}">View</a></td>
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="19">No Record Found !!</td>
                                    </tr>

                                    @endforelse


                                </tbody>
                            </table>
                          
                        </div>
                       
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</main>
@endsection
