@extends('admin.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">View Branch</h2>
           
                <form action="{{url('/admin/view-branch')}}" method="get">
                <div class="row">
                   <div class="col-md-3">
                        <label for="">Branch</label>
                        <select name="branch" id="branch" class="form-control">
                            <option value="">All</option>
                            @foreach($branch as $key=>$val)
                                <option value="{{$val->id}}">{{$val->branch_name}} ({{$val->branch_code}})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <input type="submit" class="btn btn-primary" value="Filter" style="margin-top: 25px;">
                    </div>
                    </div>
                </form>
           <br>

            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th width="5%">S.No.</th>
                                            <th>Branch Code</th>
                                            <th>Branch Name</th>
                                            <th>State</th>
                                            <th>District</th>
                                            <th>Branch Contact Person</th>
                                            <th>Branch Contact Number</th>
                                            <th>Branch Email ID</th>
                                            <th>Branch Address</th>
                                            <th>Password </th>
                                            <th>Status</th>
                                            <th>Edit</th>
                                            <th>Permissions view</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        @forelse ($branchList as $key =>$value)
                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{$value->branch_code}}</td>
                                            <td>{{ $value->branch_name }}</td>
                                            <td>{{ $value->state }}</td>
                                            <td>{{ $value->district }}</td>
                                            <td>{{ $value->branch_contact_person }}</td>
                                            <td>{{ $value->branch_contact_number }}</td>
                                            <td>{{ $value->email}}</td>
                                            <td>{{ $value->branch_address}}</td>
                                            <td>******</td>
                                             <td>{{ ($value->status == 1) ? 'Active' : 'Inactive' }}</td>
                                            <td><a href="{{url('/admin/branch-update')}}/{{$value->id}}"><i class="far fa-edit"></i> </a> </td>
                                            <!--- <td><a href="#"><i class="far fa-trash-alt"></i> Delete</a></td> -->
                                       <td>  <button type="button" class="btn btn-primary" data-toggle="modal"  data-target="#exampleModal{{$value->branch_code}}">
                                                view
                                            </button></td>
                                        </tr>

                                        <!-- Button trigger modal -->


                                            <!-- Modal -->
                                            <div class="modal fade bd-example-modal-lg" id="exampleModal{{$value->branch_code}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        @php
                                                              $permission_groups = App\Models\ModelType::where('parent_id', 0)->where('type','branch')->with(['SubModel'])->get();
                                                              $branch = App\Models\Branch::where('branch_code', $value->branch_code)->first();
                                                        @endphp
                                                        <form action="{{route('admin.role_has_permissions.branch.role')}}" method="POST">
                                                            @csrf
                                                            <input type="hidden" name="branch_code" value="{{$branch->branch_code}}">
                                                            <div class="form-group">
                                                                <label for="name">Branch Name</label>
                                                                <input type="text" class="form-control" id="name" readonly name="name" value="{{$branch->branch_name}}" placeholder="Enter a Role Name">
                                                            </div>

                                                            <div class="form-group">
                                                                <label for="name">Permissions</label>

                                                                <div class="form-check">
                                                                    <input onclick="allCheckBoc('{{$branch->branch_code}}')" type="checkbox" class="form-check-input" id="checkPermissionAll_{{$branch->branch_code}}" value="1">
                                                                    <label class="form-check-label" for="checkPermissionAll">All</label>
                                                                </div>
                                                                <hr>
                                                                @php $i = 1; @endphp
                                                                @foreach ($permission_groups as $group)
                                                                    <div class="row">
                                                                        <div class="col-3">
                                                                            <div class="form-check">
                                                                                <input type="checkbox" onclick="parentIDSET({{$group->id}},'{{$value->branch_code}}')" class="form-check-input checkPermission_{{$branch->branch_code}}" {{App\Models\PermissionsBranch::where([['branch_code',$branch->branch_code],['model_type',$group->id]])->first() ? 'checked' : '' }} name="Parent_{{ $group->id}}[]" id="checkPermissionParent_{{ $group->id }}_{{$value->branch_code}}" value="{{ $group->model_name}}" >
                                                                                <label class="form-check-label" for="checkPermission">{{ $group->model_name	 }}</label>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-9 role-{{ $group->id }}-management-checkbox">
                                                                            @php  $j=1; @endphp
                                                                            @foreach ($group->SubModel as $permission)

                                                                                <div class="form-check">
                                                                                    <input type="checkbox" onclick="childIDSET({{$group->id}},'{{$value->branch_code}}')" class="form-check-input checkPermission_{{$branch->branch_code}} checkPermission_{{ $group->id }}_{{$value->branch_code}}" {{App\Models\PermissionsBranch::where([['branch_code',$branch->branch_code],['model_id',$permission->id]])->first() ? 'checked' : '' }} name="permissions_{{ $group->id}}[]" id="checkPermission_{{ $group->id }}_{{$value->branch_code}}" value="{{ $permission->id }}">
                                                                                    <label class="form-check-label" for="checkPermission{{ $permission->id }}">{{ $permission->model_name	 }}</label>
                                                                                </div>
                                                                                @php  $j++; @endphp
                                                                            @endforeach
                                                                            <br>
                                                                        </div>

                                                                    </div>
                                                                    @php  $i++; @endphp
                                                                @endforeach

                                                            </div>

                                                            <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Update Permissions</button>
                                                        </form>
                                                    </div>
                                                    <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    {{-- <button type="button" class="btn btn-primary">Save changes</button> --}}
                                                    </div>
                                                </div>
                                                </div>
                                            </div>
                                        @empty

                                        <tr>
                                            <td colspan="8">No Record Found !!</td>
                                        </tr>

                                        @endforelse
                                    </tbody>
                                </table>
                                {!!$branchList->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>
@endsection


<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
    function parentIDSET(id,code){
    // alert(id);
    // alert(code);

   var checkBox = $('#checkPermissionParent_' + id+'_'+code).is(":checked");
   if(checkBox == true){
    $(".checkPermission_" + id+'_'+code).prop("checked", true);
   }else{
    $(".checkPermission_" + id+'_'+code).prop("checked",false);
   }

}

function childIDSET(id,code){
    // alert(id);
    $("#checkPermissionParent_" + id+'_'+code).prop("checked", true);
}
function allCheckBoc(code){

var checkBox = $('#checkPermissionAll_'+code).is(":checked");
// alert(checkBox)
if(checkBox == true){
    // alert(checkBox)
    // alert(0)
    $(".checkPermission_"+code).prop("checked", true);
}else{
    // alert(checkBox)
    // alert(1)
$(".checkPermission_"+code).prop("checked", false);
}

}
</script>

