@extends('admin.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">View Operator</h2>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                    </div>
                    <form action="{{url('/admin/view-operator')}}" method="get">
                        <div class="card-body" id="demo">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>From Date</label>
                                    <input type="date" name="from_date" id="from_date" class="form-control"
                                        value="{{ Request::get('from_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>To Date</label>
                                    <input type="date" name="to_date" id="to_date" class="form-control"
                                        value="{{ Request::get('to_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Registrar EA Combination</label>
                                    <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($registrars as $key => $val)
                                        <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                            'selected' : '' }}>
                                            {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                           
                            

                           
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($state as $key => $state)
                                        <option value="{{ $state }}" {{ Request::get('state')==$state ? 'selected' : ''
                                            }}>
                                            {{ $state }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>District </label>
                                    <select name="District" id="district" onchange="districtFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($District as $key => $val)
                                        <option value="{{ $val }}" {{ Request::get('District')==$val ? 'selected' : ''
                                            }}>
                                            {{ $val }} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Branch</label>
                                    <select name="branch_code" id="branch" onchange="branchFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($branches as $key => $val)
                                    
                                        <option value="{{ $val->branch_code }}" {{ Request::get('branch_code')==$val->branch_code ?
                                            'selected' : '' }}>
                                            {{ $val->branch_code }} ({{ $val->branch_name }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Operator</label>
                                    <select name="operator_code" id="operator" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($operatorListAll as $key => $val)
                                        <option value="{{ $val->Operator_Code }}" {{
                                            Request::get('operator_code')==$val->Operator_Code ? 'selected' : '' }}>
                                            {{ $val->Operator_Code }}
                                            ({{ $val->Operator_Name }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input type="submit" class="btn btn-primary" value="Filter" style="margin-top:25px; float:right;">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-12"></div>
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                        <a onclick="downloadExcel()" class="btn btn-primary"><i class="fa fa-download"></i> Operator
                            List Download </a>
                      </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" style="height: 600px; width:4058px;"
                                cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Registrar Code</th>
                                        <th>EA Code</th>
                                        <th>Operator Code</th>
                                        <th>Operator Name</th>
                                        <th>Aadhaar Number</th>
                                        <th>SALARY</th>
                                        <th>PF No</th>
                                        <th>ESI No</th>
                                        <th>Station Code</th>
                                        <th>NSE IT Certificate</th>
                                        <th>VTC Village Town City</th>
                                        <th>Post Office</th>
                                        <th>Block</th>
                                        <th>District</th>
                                        <th>State</th>
                                        <th>Center Address</th>
                                        <th>Email ID</th>
                                        <th>Mobile No</th>
                                        <th>Residence_Address </th>
                                        <th>Father_monile_no</th>
                                        <th>Latitude</th>
                                        <th>Longitude </th>
                                        <th>Any Desk ID</th>
                                        <th>view passsword</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                        <th width="10%">Permissions</th>
                                        <!--   <th width="10%"></th> -->

                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($operatorList as $key =>$value)
                                    <tr>
                                        <td>{{ $key + $operatorList->firstItem() }}.</td>
                                        <td>{{ $value->Registrar_Code }}</td>
                                        <td>{{ $value->EA_Code }}</td>
                                        <td>{{ $value->Operator_Code }}</td>
                                        <td>{{ $value->Operator_Name }}</td>
                                        <td>{{ $value->Aadhaar_Number }}</td>
                                        <td>{{ $value->SALARY }}</td>
                                        <td>{{ $value->PF_No }}</td>
                                        <td>{{ $value->ESI_No }}</td>
                                        <td>{{ $value->Station_Code }}</td>
                                        <td>{{ $value->NSE_IT_Certificate }}</td>
                                        <td>{{ $value->VTC_Village_Town_City }}</td>
                                        <td>{{ $value->Post_Office }}</td>
                                        <td>{{ $value->Block }}</td>
                                        <td>{{ $value->District }}</td>
                                        <td>{{ $value->State }}</td>
                                        <td>{{ $value->Center_Address }}</td>
                                        <td>{{ $value->Email_ID }}</td>
                                        <td>{{ $value->Mobile_No }}</td>
                                        <td>{{ $value->Residence_Address }}</td>
                                        <td>{{ $value->Father_monile_no }}</td>
                                        <td>{{ $value->Latitude }}</td>
                                        <td>{{ $value->Longitude }}</td>
                                        <td>{{ $value->Any_Desk_ID }}</td>
                                        <td>{{ $value->view_password }}</td>
                                        <td>
                                            <select name="status" onchange="test(this,{{ $value->id }})"
                                                id="status_{{ $value->id }}_{{ $value->status }}">
                                                <option value="1" {{ $value->status == '1' ? 'selected' : '' }}>Active
                                                </option>
                                                <option value="2" {{ $value->status == '2' ? 'selected' : '' }}>Inactive
                                                </option>
                                                <option value="3" {{ $value->status == '3' ? 'selected' : '' }}>
                                                    Disassociated </option>
                                                <option value="0" {{ $value->status == '0' ? 'selected' : '' }}>
                                                    Blacklisted </option>
                                            </select>
                                        </td>
                                        <td><a href="{{ route('edit.operator', [$value->Operator_Code]) }}"><i
                                                    class="far fa-edit"></i> Edit</a>
                                        </td>
                                        {{-- <td><a href="#"><i class="far fa-trash-alt"></i> Delete</a></td> --}}
                                     <td>  <button type="button" class="btn btn-primary" data-toggle="modal"  data-target="#exampleModal{{$value->Operator_Code}}">
                                            view
                                        </button></td>
                                    </tr>

                                    <!-- Button trigger modal -->


                                        <!-- Modal -->
                                        <div class="modal fade bd-example-modal-lg" id="exampleModal{{$value->Operator_Code}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                                </div>
                                                <div class="modal-body">
                                                    @php
                                                        $permission_groups = App\Models\ModelType::where('parent_id', 0)->where('type','operators')->with(['SubModel'])->get();
                                                    @endphp
                                                    <form action="{{route('admin.role_has_permissions.operator.role')}}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="operator_code" value="{{$value->Operator_Code}}">
                                                        <div class="form-group">
                                                            <label for="name">Operator code</label>
                                                            <input type="text" class="form-control" id="name" readonly name="name" value="{{$value->Operator_Code}}" placeholder="Enter a Role Name">
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="name">Permissions</label>

                                                            <div class="form-check">
                                                                <input type="checkbox" onclick="allCheckBoc('{{$value->Operator_Code}}')" class="form-check-input" id="checkPermissionAll_{{$value->Operator_Code}}"  value="1">
                                                                <label class="form-check-label" for="checkPermissionAll">All</label>
                                                            </div>
                                                            <hr>
                                                            @php $i = 1; @endphp
                                                            @foreach ($permission_groups as $group)
                                                                <div class="row">
                                                                    <div class="col-3">
                                                                        <div class="form-check">
                                                                            <input type="checkbox" onclick="parentIDSET({{$group->id}},'{{$value->Operator_Code}}')" class="form-check-input checkPermission_{{$value->Operator_Code}}" {{App\Models\PermissionsOperator::where([['operator_code',$value->Operator_Code],['model_type',$group->id]])->first() ? 'checked' : '' }} name="Parent_{{ $group->id}}[]" id="checkPermissionParent_{{ $group->id }}_{{$value->Operator_Code}}" value="{{ $group->model_name}}" >
                                                                            <label class="form-check-label" for="checkPermission">{{ $group->model_name	 }}</label>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-9 role-{{ $group->id }}-management-checkbox">
                                                                        @php  $j=1; @endphp
                                                                        @foreach ($group->SubModel as $permission)

                                                                            <div class="form-check">
                                                                                <input type="checkbox" onclick="childIDSET({{$group->id}},'{{$value->Operator_Code}}')" class="form-check-input checkPermission_{{$value->Operator_Code}} checkPermission_{{ $group->id }}_{{$value->Operator_Code}}" {{App\Models\PermissionsOperator::where([['operator_code',$value->Operator_Code],['model_id',$permission->id]])->first() ? 'checked' : '' }} name="permissions_{{ $group->id}}[]" id="checkPermission_{{ $group->id }}_{{$value->Operator_Code}}" value="{{ $permission->id }}">
                                                                                <label class="form-check-label" for="checkPermission{{ $permission->id }}">{{ $permission->model_name	 }}</label>
                                                                            </div>
                                                                            @php  $j++; @endphp
                                                                        @endforeach
                                                                        <br>
                                                                    </div>

                                                                </div>
                                                                @php  $i++; @endphp
                                                            @endforeach

                                                        </div>

                                                        <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Update Permissions</button>
                                                    </form>
                                                </div>
                                                <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                {{-- <button type="button" class="btn btn-primary">Save changes</button> --}}
                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                    @empty

                                    <tr>
                                        <td colspan="8">No Record Found !!</td>
                                    </tr>
                                    @endforelse


                                </tbody>
                            </table>
                            {!! $operatorList->appends($_GET)->links() !!}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    function downloadExcel(){
        var from_date     = $('#from_date').val();
        var to_date       = $('#to_date').val();
        var operator_code = $('#operator').val();
        var Ea_Code   = $('#eacode').val();
        var state   = $('#state').val();
        var branch_code   = $('#branch').val();
        var district      = $('#district').val();
        // alert(operator_code);
        window.location.href = "{{url('/admin/get-excel-operator-list')}}/?from_date="+from_date+"&to_date="+to_date+"&operator_code="+operator_code+"&district="+district+"&state="+state+"&Ea_Code="+Ea_Code;
    }
    

    function test(a, id) {
        // alert(a);
        // alert(id);
        // alert('id');
        var x = (a.value || a.options[a.selectedIndex].value); //crossbrowser solution =)

        $.ajax({
            type: "post",
            url: "{{ route('admin.StatusChange') }}",
            data: {
                'id': id,
                "status": x,
                "_token": "{{ csrf_token() }}"
            },
            success: function(res) {
                if (res.data == 1) {
                    toastr.success("successfully");
                     } else {
                    toastr.error("fail!");
                }
            }
        });

    }
</script>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
    function parentIDSET(id,code){
    // alert(id);
    // alert(code);

   var checkBox = $('#checkPermissionParent_' + id+'_'+code).is(":checked");
   if(checkBox == true){
    $(".checkPermission_" + id+'_'+code).prop("checked", true);
   }else{
    $(".checkPermission_" + id+'_'+code).prop("checked",false);
   }

}

function childIDSET(id,code){
    // alert(id);
    $("#checkPermissionParent_" + id+'_'+code).prop("checked", true);
}
function allCheckBoc(code){

var checkBox = $('#checkPermissionAll_'+code).is(":checked");
// alert(checkBox)
if(checkBox == true){
    // alert(checkBox)
    // alert(0)
    $(".checkPermission_"+code).prop("checked", true);
}else{
    // alert(checkBox)
    // alert(1)
$(".checkPermission_"+code).prop("checked", false);
}

}
</script>
@endsection