@extends('branch.layouts.master')
@section('main-content')
@php
$mytime = Carbon\Carbon::now('Asia/Kolkata');
 use Carbon\Carbon;
@endphp
<style>
    /* Add your CSS styles here */



    input[type="submit"] {
        padding: 10px;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }
</style>
<main>
    <div class="container">
        <div class="row">
            <div class="card-body">
                <table width="420" border="1" cellspacing="2" cellpadding="1" class="tdrow4" align="center">

                    <tbody>
                        <tr align="center">
                            <td colspan="2" class="txt">Attendance Entry Form <strong>(Coming time @isset($attendance)
                                    {{ date("H:i:s A", strtotime($attendance->in_time))}}
                                    @else
                                    {{$mytime->format('H:i:s A')}}
                                    @endisset)</strong>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <table id="ContentPlaceHolder1_tblGMGN" width="420" border="1" cellspacing="2" cellpadding="1"
                    class="tdrow4" align="center">
                    <form action=" @isset($attendance)
                        {{route('branch.attendance.post.night')}}
                        @else
                        {{route('branch.attendance.post.morning')}}
                    @endisset" method="post">
                        @csrf
                        <tbody>
                            <tr class="rowDate">
                                <td width="199" align="right" class="Tab3"><strong>Date</strong></td>
                                <td width="185">

                                    <input name="date" type="text" value="{{ $mytime->format('Y-m-d H:i:s')}}"
                                        readonly="readonly" id="ContentPlaceHolder1_txt_date" size="30">
                                    <span id="ContentPlaceHolder1_RequiredFieldValidator4"
                                        style="color:Red;display:none;">*</span>
                                </td>
                            </tr>
                            <tr align="center" class="rowMessage">
                                <td width="199" align="right" class="Tab3"></td>
                                <td width="185">
                                    <textarea name="message" rows="5" cols="50" id="ContentPlaceHolder1_txtmessage"
                                        placeholder="Enter Message,If Any?" size="30"></textarea>
                                </td>
                            </tr>
                            <tr align="center">
                                <td colspan="2">
                                    <span id="ContentPlaceHolder1_lberror" style="color:Red;"></span>

                                    <br>
                                    @isset($attendance)
                                    <input type="submit" @if ($attendance->out_time)
                                    disabled
                                    @endif name="ctl00$ContentPlaceHolder1$btnnight" title="I have completed my all
                                    today's assigned work, should I leave now?"
                                    value="I have completed my all today's assigned work, should I leave now?"
                                    id="ContentPlaceHolder1_btnnight" class="Tab2"
                                    >
                                    @else
                                    <input type="submit" name="ctl00$ContentPlaceHolder1$btnnight" value="Good Morning"
                                        id="ContentPlaceHolder1_btnnight" title="Submit" class="Tab2"
                                        style="cursor: pointer;">
                                    @endisset
                                    <br>

                                    <span id="ContentPlaceHolder1_lblmsg" style="color:Red;"></span>



                                    <span id="ContentPlaceHolder1_txtmsg" class="txtmsgg"
                                        style="color:Green;"></span><br>

                                    <span id="ContentPlaceHolder1_txtmsg1" class="txtmsgg1" style="color:Green;"></span>



                                </td>
                            </tr>
                        </tbody>
                    </form>
                </table>
            </div>
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th width="5%">S.No.</th>
                                        <th width="8%">Date</th>                                          
                                        <th width="10%">In Time</th>
                                        <th width="10%">In message</th>
                                        <th width="10%">Out Time</th>                                        
                                        <th width="10%">Out message</th>                                        
                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($attendances as $key =>$val)
                                    <tr>
                                       
                                        <td>{{ $key+1 }}.</td>
                                        <td>{{ Carbon::parse($val->date)->format('d-M-Y')}}</td>                                        
                                        <td>{{date("h:i:s A", strtotime($val->in_time))}}</td>
                                        <td>{{$val->message_morning}}</td>
                                        <td>{{isset($val->out_time) ? date("h:i:s A", strtotime($val->out_time)) : ''}}</td>
                                        <td>{{$val->message_night}}</td>                                        
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="6">No Record Found !!</td>
                                    </tr>

                                    @endforelse



                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>
    </div>
</main>

@endsection