@extends('branch.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">Upload Received Amount List</h2>

            <div class="row">
                <div class="card-body">
                    <form action="{{url('branch/receive-amount-list')}}" method="get">
                        <div class="col-md-2">
                            <label for="">From Date</label>
                            <input type="date" name="from_date" value="{{Request::get('from_date')}}" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">To Date</label>
                            <input type="date" name="to_date" value="{{Request::get('to_date')}}" class="form-control">
                        </div>
                        <!-- <div class="col-md-2">
                            <div class="form-group">
                                <label>Registrar EA Combination</label>
                                <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                    <option value="">All</option>
                                    @foreach (DB::table('registrars')->get() as $key => $val)
                                    <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                        'selected' : '' }}>
                                        {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div> -->
                       
                        <div class="col-md-2">
                            <label for="">State</label>
                            <select name="state" id="state" onchange="stateFun()" class="form-control">
                                <option value="">All</option>
                                @foreach($state as $key=>$val)
                                <option value="{{$val->state}}" {{Request::get('state')==$val->state?'selected':''}}>{{$val->state}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="">District</label>
                            <select name="district" id="district" onchange="districtFun()" class="form-control">
                                <option value="">All</option>
                                @foreach($districtData as $key=>$val)
                                <option value="{{$val->District}}" {{Request::get('district')==$val->
                                    District?'selected':''}}>{{$val->District}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="">Operator</label>
                            <select name="operator" id="operator"  class="form-control"
                                style="width: 100%;">
                                <option value="">All</option>
                                @foreach($operatorData as $key=>$val)
                                <option value="{{$val->Operator_Code}}" {{Request::get('operator')==$val->
                                    Operator_Code?'selected':''}}>{{$val->Operator_Code}} ({{$val->Operator_Name}})</option>
                                @endforeach
                            </select>
                        </div>
                                       
                        <div class="col-md-2">
                            <label for=""></label>
                            <input type="submit" value="Search" class="btn btn-primary" style="margin: 25px; float:right;">
                        </div>

                    </form>
                </div>
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th >S.No.</th>
                                            <th >Date Of Transaction</th>
                                            <th >Registrar Code</th>
                                            <th >EA Code</th>
                                            
                                            <th>Branch Code</th>
                                            <th>Operator Code</th>
                                            <th>Operator Name</th>
                                            <th >State</th>
                                            <th >District</th>
                                            <th >Station Code	</th>
                                            <th>Amount Credited</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                        @forelse ($List as $key =>$val)
                                        <tr>
                                            <td>{{ $key+$List->firstItem() }}.</td>
                                            <td>{{$val->date_of_transaction}}</td>
                                            <td>{{$val->registrar_code}}</td>
                                            <td>{{$val->ea_code}}</td>
                                            
                                            <td>{{$val->branch_code}}</td>
                                            <td>{{$val->Operator_Code}}</td>
                                            @php
                                                $opData = DB::table('operators')->select('Operator_Name')->where('Operator_Code',$val->Operator_Code)->first();
                                            @endphp
                                            <td>{{!empty($opData) ? $opData->Operator_Name : ''}}</td>
                                            <td>{{$val->state}}</td>
                                            <td>{{$val->district}}</td>
                                            <td>{{$val->station_code}}</td>
                                            <td>{{$val->amount_credited}}</td>
                                        </tr>
                                        @empty

                                        <tr>
                                            <td colspan="8">No Record Found !!</td>
                                        </tr>

                                        @endforelse


                                    </tbody>
                                </table>
                                {!!$List->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

@endsection