@extends('branch.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Fund Deposit Report</h2>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">

                    </div>
                    <div class="responsive">
                        <form action="{{url('/branch/report/fund-deposit-report')}}" method="get">
                            <div class="card-body" id="demo">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">From Date</label>
                                        <input type="date" class="form-control" name="from_date" id="from_date" value="{{Request::get('from_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">To Date</label>
                                        <input type="date" class="form-control" name="to_date" id="to_date" value="{{Request::get('to_date')}}">
                                    </div>
                                </div>
                                <!-- <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Registrar EA Combination</label>
                                        <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                            <option value="">All</option>
                                            @foreach (DB::table('registrars')->get() as $key => $val)
                                            <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                                'selected' : '' }}>
                                                {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> -->
                                <div class="col-md-2">
                                    <label for="">State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($state as $key=>$val)
                                        <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">District</label>
                                        <select name="district" id="district" onchange="districtFun()" class="form-control">
                                            <option value="">All</option>
                                            @foreach($districtList as $key=>$val)
                                             <option value="{{$val->District}}" {{Request::get('district') == $val->District ? 'selected':''}}>{{$val->District}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">Operator Name</label>
                                        <select name="operator_code" id="operator"  class="form-control">
                                            <option value="">All</option>
                                            @foreach($operatorList as $key=>$val)
                                            <option value="{{$val->Operator_Code}}" {{Request::get('operator_code') == $val->Operator_Code ? 'selected':''}}>{{$val->Operator_Code}} {{$val->Operator_Name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <input type="submit" class="btn btn-primary" value="Filter" style="margin: 25px; float:right;">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <br>
            </div>

            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <!-- <h6 class="card-title"></h6> -->
                        <a onclick="excelDownload()" class="btn btn-primary"><i class="fa fa-download"></i> Fund Deposit
                            Report</a>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th width="5%">S.No.</th>
                                        <th width="8%">Transaction Date</th>
                                        <th width="12%">Branch</th>
                                        <th width="20%">District</th>
                                        <th width="10%">Operator ID</th>
                                        <th width="10%">Operator Name</th>
                                        <th width="10%">Station Code </th>
                                        <th>Transaction Amount</th>
                                        <th>Transaction Number </th>

                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($enrollmentList as $key =>$val)
                                    <tr>
                                        <td>{{ $key+ $enrollmentList->firstItem() }}.</td>
                                        <td>{{date('d-m-Y',strtotime($val->date_of_transaction))}}</td>
                                        <td>{{$val->branch_name}}</td>
                                        <td>{{$val->district}}</td>
                                        <td>{{$val->Operator_Code}}</td>
                                        <td>{{$val->Operator_Name}}</td>
                                        <td>{{$val->Station_Code}}</td>
                                        <td>{{$val->amount_credited}}</td>
                                        <td>{{$val->transaction_no}}</td>
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="19">No Record Found !!</td>
                                    </tr>

                                    @endforelse

                                </tbody>
                            </table>
                            {!!$enrollmentList->links()!!}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>
<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    function excelDownload(){
            var from_date = $('#from_date').val();
            var to_date   = $('#to_date').val();
            var eacode = "";//$('#eacode').val();
            var state = $('#state').val();
            var district = $('#district').val();
            var operator = $('#operator').val();

            window.location.href="{{url('/branch/get-excel-fund-deposit')}}?from_date="+from_date+"&to_date="+to_date+"&eacode="+eacode+"&state="+state+"&district="+district+"&operator="+operator;
             
        }
</script>
@endsection