@extends('branch.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">PSPL Report List</h2>

            <div class="row">
            <div class="col-md-12">
            <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                        </div>
                        <form action="{{url('/branch/report/pspl-report')}}" method="get">
                            <div class="card-body" id="demo">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">From Date</label>
                                        <input type="date" class="form-control" name="from_date" id="from_date" value="{{Request::get('from_date')}}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">To Date</label>
                                        <input type="date" class="form-control" name="to_date" id="to_date" value="{{Request::get('to_date')}}">
                                    </div>
                                </div>
                                <!-- <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Registrar EA Combination</label>
                                        <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                            <option value="">All</option>
                                            @foreach (DB::table('registrars')->get() as $key => $val)
                                            <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                                'selected' : '' }}>
                                                {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> -->
                                <div class="col-md-2">
                                    <label for="">State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control">
                                        <option value="">All</option>
                                        @foreach($state as $key=>$val)
                                        <option value="{{$val->state}}" {{Request::get('state')==$val->state ? 'selected':''}}>{{$val->state}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">District</label>
                                        <select name="district" id="district" onchange="districtFun()" class="form-control">
                                            <option value="">All</option>
                                            @foreach($districtList as $key=>$val)
                                             <option value="{{$val->District}}" {{Request::get('district') == $val->District ? 'selected':''}}>{{$val->District}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                              
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">Operator Name</label>
                                        <select name="operator_code" id="operator"  class="form-control">
                                            <option value="">All</option>
                                            @foreach($operatorList as $key=>$val)
                                            <option value="{{$val->Operator_Code}}" {{Request::get('operator_code') == $val->Operator_Code ? 'selected':''}}>{{$val->Operator_Code}} {{$val->Operator_Name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-2">
                                    <input type="submit" class="btn btn-primary" value="Filter" style="margin: 25px; float:right;">
                                </div>
                            </div>
                        </form>
                </div>
            </div>
            <div class="col-md-12"></div>
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h6 class="card-title"></h6>
                            <a onclick="downloadExcel()" class="btn btn-primary" ><i class="fa fa-download"></i> PSPL Report</a>
                            <button class="btn btn-primary"><i class="fa fa-download"></i> Shreetron Report</button>
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th width="5%">S.No.</th>
                                            <th width="8%">Branch Code</th>
                                            <th width="12%">Date of Enrolment</th>
                                            <th width="20%">Station_ID</th>
                                            <th width="10%">Operator_ID</th>
                                            <th width="10%">Operator Name</th>
                                            <th width="10%">District</th>
                                            <th>State	</th>
                                            <th>Pincode	</th>
                                            <th>Total No of Enrollment</th>
                                            <th>Total No of update</th>
                                            <th>New Enrolments</th>
                                            <th>Demographic Updates </th>
                                            <th>Mandatory Biometric Updates(5/15 years)	</th>
                                            <th>Biometric Updates	</th>
                                            <th>Total Amount Collected Towards Demographic Updates.	</th>
                                            <th>Total Amount  Collected Towards Biometric Updates	</th>
                                            <!--<th>Total Amount Credited to ProMind's Account</th>-->
                                            <th>Total Amount to be Collected</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($enrollmentList as $key =>$val)
                                        @php
                                          $bankAmt = 0;
                                          $bankData = DB::table('bankuplods')->select('amount_credited')->where('Operator_Code',$val['Operator_Code'])->whereDate('date_of_transaction',$val->c_date)->first();
                                        @endphp
                                        <tr>
                                            <td>{{ $key+$enrollmentList->firstItem() }}.</td>
                                            <td>{{$val['branch_code']}}</td>
                                            <td>{{date('d-m-Y', strtotime($val['c_date']))}}</td>
                                            <td>{{$val['Station_ID']}}</td>
                                            <td>{{$val['Operator_Code']}}</td>
                                            <td>{{$val['Operator_Name']}}</td>
                                            <td>{{$val['District']}}</td>
                                            <td>{{$val['State']}}</td>
                                            <td>{{$val['pincode']}}</td>
                                            <td>{{$val['total_enrollment']}}</td>
                                            <td>{{$val['total_no_of_update']}}</td>
                                            <td>{{$val['new_enrollments']}}</td>
                                            <td>{{$val['total_demographic_update']}}</td>
                                            <td>{{$val['mandatory_bio_biometric_update']}}</td>
                                            <td>{{$val['biometric_update']}}</td>
                                            <td>{{$val['total_amount_collected_A']}}</td>
                                            <td>{{$val['total_amount_collected_B']}}</td>
                                            @if(isset($bankData))
                                                @php
                                                $total_pending = (($val['total_amount_collected_A']+$val['total_amount_collected_B'])-$bankData->amount_credited);
                                                @endphp
                                            @else
                                            @php
                                            $total_pending = ($val['total_amount_collected_A']+$val['total_amount_collected_B']);
                                            @endphp
                                            @endif
                                            <td>{{$total_pending}}</td>
                                        </tr>
                                        @empty

                                        <tr>
                                            <td colspan="19">No Record Found !!</td>
                                        </tr>

                                        @endforelse


                                    </tbody>
                                </table>
                                {!!$enrollmentList->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>

   <!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    function downloadExcel(){
        var from_date     = $('#from_date').val();
        var to_date       = $('#to_date').val();
        var operator_code = $('#operator').val();
        var district      = $('#district').val();
        var Ea_Code        = '';

        window.location.href = "{{url('/branch/get-excel-report')}}/?from_date="+from_date+"&to_date="+to_date+"&operator_code="+operator_code+"&district="+district+"&Ea_Code="+Ea_Code;
    }

</script>
@endsection
