@extends('branch.layouts.master')
@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">View Operator</h2>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                    </div>
                    <form action="{{url('/branch/view-operator')}}" method="get">
                        <div class="card-body" id="demo">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>From Date</label>
                                    <input type="date" name="from_date" id="from_date" class="form-control"
                                        value="{{ Request::get('from_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>To Date</label>
                                    <input type="date" name="to_date" id="to_date" class="form-control"
                                        value="{{ Request::get('to_date') }}">
                                </div>
                            </div>
                          


                            <!-- <div class="col-md-2">
                                <div class="form-group">
                                    <label>Registrar EA Combination</label>
                                    <select name="Ea_Code" id="eacode" onchange="eacodeFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($registrars as $key => $val)
                                        <option value="{{ $val->Ea_Code }}" {{ Request::get('Ea_Code')==$val->Ea_Code ?
                                            'selected' : '' }}>
                                            {{ $val->Ea_Code }} ({{ $val->Ea_Name }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> -->
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>State</label>
                                    <select name="state" id="state" onchange="stateFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($state as $key => $state)
                                        <option value="{{ $state }}" {{ Request::get('state')==$state ? 'selected' : ''
                                            }}>
                                            {{ $state }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>District </label>
                                    <select name="District" id="district" onchange="districtFun()" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($District as $key => $val)
                                        <option value="{{ $val }}" {{ Request::get('District')==$val ? 'selected' : ''
                                            }}>
                                            {{ $val }} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Operator</label>
                                    <select name="operator_code" id="operator" class="form-control select2">
                                        <option value="">All</option>
                                        @foreach ($operatorList as $key => $val)
                                        <option value="{{ $val->Operator_Code }}" {{
                                            Request::get('operator_code')==$val->Operator_Code ? 'selected' : '' }}>
                                            
                                            {{ $val->Operator_Name }}
                                            ({{ $val->Operator_Code }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div> 
                            <div class="col-md-2">
                                <input type="submit" class="btn btn-primary" value="Filter" style="margin-top: 25px; float:right;">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-12"></div>
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title"></h6>
                        <a onclick="downloadExcel()" class="btn btn-primary"><i class="fa fa-download"></i> Operator
                            List Download </a>
                    </div>
                    <div class="card-body" id="demo">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped"  style="width:4000px; height: 600px;"
                                cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Registrar Code</th>
                                        <th>EA Code</th>
                                        <th>Operator Code</th>
                                        <th>Operator Name</th>
                                        <th>Aadhaar Number</th>
                                        <th>SALARY</th>
                                        <th>PF No</th>
                                        <th>ESI No</th>
                                        <th>Station Code</th>
                                        <th>NSE IT Certificate</th>
                                        <th>VTC Village Town City</th>
                                        <th>Post Office</th>
                                        <th>Block</th>
                                        <th>District</th>
                                        <th>State</th>
                                        <th>Center Address</th>
                                        <th>Email ID</th>
                                        <th>Mobile No</th>
                                        <th>Residence_Address </th>
                                        <th>Father_monile_no</th>
                                        <th>Latitude</th>
                                        <th>Longitude </th>
                                        <th>Any Desk ID</th>
                                        <th>view passsword</th>
                                        <th>Status</th>

                                        <!--<th>Action</th>-->
                                        <!--   <th width="10%"></th> -->

                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($operatorList as $key =>$value)
                                    <tr>
                                        <td>{{ $key + $operatorList->firstItem() }}.</td>
                                        <td>{{ $value->Registrar_Code }}</td>
                                        <td>{{ $value->EA_Code }}</td>
                                        <td>{{ $value->Operator_Code }}</td>
                                        <td>{{ $value->Operator_Name }}</td>
                                        <td>{{ $value->Aadhaar_Number }}</td>
                                        <td>{{ $value->SALARY }}</td>
                                        <td>{{ $value->PF_No }}</td>
                                        <td>{{ $value->ESI_No }}</td>
                                        <td>{{ $value->Station_Code }}</td>
                                        <td>{{ $value->NSE_IT_Certificate }}</td>
                                        <td>{{ $value->VTC_Village_Town_City }}</td>
                                        <td>{{ $value->Post_Office }}</td>
                                        <td>{{ $value->Block }}</td>
                                        <td>{{ $value->District }}</td>
                                        <td>{{ $value->State }}</td>
                                        <td>{{ $value->Center_Address }}</td>
                                        <td>{{ $value->Email_ID }}</td>
                                        <td>{{ $value->Mobile_No }}</td>
                                        <td>{{ $value->Residence_Address }}</td>
                                        <td>{{ $value->Father_monile_no }}</td>
                                        <td>{{ $value->Latitude }}</td>
                                        <td>{{ $value->Longitude }}</td>
                                        <td>{{ $value->Any_Desk_ID }}</td>
                                        <td>{{ $value->view_password }}</td>
                                        <td>
                                            <!-- onchange="test(this,{{ $value->id }})"-->
                                            <select name="status"
                                                id="status_{{ $value->id }}_{{ $value->status }}" disabled>
                                                <option value="1" {{ $value->status == '1' ? 'selected' : '' }}>Active
                                                </option>
                                                <option value="2" {{ $value->status == '2' ? 'selected' : '' }}>Inactive
                                                </option>
                                                <option value="3" {{ $value->status == '3' ? 'selected' : '' }}>
                                                    Disassociated </option>
                                                <option value="0" {{ $value->status == '0' ? 'selected' : '' }}>
                                                    Blacklisted </option>
                                            </select>
                                        </td>
                                        <!--<td><a href="{{ route('edit.operator', [$value->Operator_Code]) }}"><i-->
                                        <!--            class="far fa-edit"></i> Edit</a>-->
                                        <!--</td>-->
                                        {{-- <td><a href="#"><i class="far fa-trash-alt"></i> Delete</a></td> --}}
                                    </tr>
                                    @empty

                                    <tr>
                                        <td colspan="8">No Record Found !!</td>
                                    </tr>
                                    @endforelse


                                </tbody>
                            </table>
                            {!! $operatorList->appends($_GET)->links() !!}
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- end -->
            </div>
        </div>

    </div>
</main>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    function downloadExcel(){
        var from_date     = $('#from_date').val();
        var to_date       = $('#to_date').val();
        var operator_code = $('#operator').val();
        var Ea_Code       = $('#eacode').val();
        var state         = $('#state').val();
        var district      = $('#district').val();
        // alert(operator_code);
        window.location.href = "{{url('/branch/get-excel-operator-list')}}/?from_date="+from_date+"&to_date="+to_date+"&operator_code="+operator_code+"&district="+district+"&state="+state+"&Ea_Code="+Ea_Code;
    }

    function test(a, id) {
        // alert(a);
        // alert(id);
        // alert('id');
        var x = (a.value || a.options[a.selectedIndex].value); //crossbrowser solution =)

        $.ajax({
            type: "post",
            url: "{{ route('branch.StatusChange') }}",
            data: {
                'id': id,
                "status": x,
                "_token": "{{ csrf_token() }}"
            },
            success: function(res) {
                if (res.data == 1) {
                    toastr.success("successfully");
                     } else {
                    toastr.error("fail!");
                }
            }
        });

    }
</script>
@endsection