@extends('operator.layouts.master')
@section('main-content')

<style>
    .card-body,
    .card-footer {
        font-size: 20px;
    }

    .card-body.largetext {
        font-size: 34px;
        font-weight: 700;
        padding-bottom: 8px;
        padding-top: 8px;
        text-align: center;
    }

    .btnstyle {
        background-color: #1976d2;
        margin-left: 3px;
        margin-bottom: 20px;
    }

    .btnstylenone {
        /* background-color: #1976d2; */
        margin-left: 3px;
        margin-bottom: 20px;
        color: #1976d2;
    }

    .spantag {
        font-size: 19px;
    }

    .fontSize {
        font-size: 13px;
    }

    /* .card p span svg{
            margin-left: 4px;
            font-size: 19px;

        } */
    .card-title {
        color: #25abe9;
    }

    .attendance {
        border: 1px solid #e1e1e170;
        padding: 15px 20px;
        border-radius: 25px;
        font-size: 14px;
        box-shadow: rgba(0, 0, 0, 0.04) 0px 3px 5px;
    }

    .card-value {
        margin-top: 0px;
    }

    .attendance.color1 h5 {
        /*color: #f1f1f1;*/
        font-size: 20px;
    }

    .attendance.color1 p {
        /*color: #fff;*/
        font-size: 15px;
        margin: 0px;
        line-height: normal;
        display: flex;
        justify-content: space-between;
    }

    .attendance.color1 p span:last-child {
        /*color: #fff;*/
        font-size: 16px;
        margin: 0px;
        line-height: 25px;
        width: fit-content;
        display: inline-block;
        font-weight: 600;
    }

    .card-title {
        display: flex;
        justify-content: space-between;
    }

    .card-title img {
        width: 56px;
        opacity: 0.3;
        filter: brightness(1) invert(1);
    }

    .sheet-data {
        border: 1px solid #0f3e6e7a;
        box-shadow: rgba(9, 30, 66, 0.25) 0px 1px 1px, rgba(9, 30, 66, 0.13) 0px 0px 1px 1px;
    }

    .custome-table thead th {
        border: 1px solid #808da5
    }

    /* Table CSS */

    .rwd-table {
        color: #333;
        border-radius: 10px;
        overflow: hidden;
        overflow-y: scroll;
    }

    .rwd-table tr:first-child {
        border-top: none;
        background: #428bca;
        color: #fff;
    }

    .rwd-table tr {
        border-top: 1px solid #ddd;
        border-bottom: 1px solid #ddd;
        background-color: #f5f9fc;
    }

    .rwd-table tr:nth-child(odd):not(:first-child) {
        background-color: #ebf3f9;
    }

    .rwd-table th {
        display: none;
    }

    .rwd-table td {
        display: block;
    }

    .rwd-table td:first-child {
        margin-top: .5em;
    }

    .rwd-table td:last-child {
        margin-bottom: .5em;
    }

    .rwd-table td:before {
        content: attr(data-th) ": ";
        font-weight: bold;
        width: 120px;
        display: inline-block;
        color: #000;
    }

    .rwd-table th,
    .rwd-table td {
        text-align: left;
    }

    .rwd-table {
        color: #333;
        border-radius: 10px;
        overflow: hidden;
    }

    .rwd-table tr {
        border-color: #bfbfbf;
    }

    .rwd-table th,
    .rwd-table td {
        padding: .5em 1em;
    }

    @media screen and (max-width: 601px) {
        .rwd-table tr:nth-child(2) {
            border-top: none;
        }
    }

    @media screen and (min-width: 600px) {
        .rwd-table tr:hover:not(:first-child) {
            background-color: #d8e7f3;
        }

        .rwd-table td:before {
            display: none;
        }

        .rwd-table th,
        .rwd-table td {
            display: table-cell;
            padding: .25em .5em;
        }

        .rwd-table th:first-child,
        .rwd-table td:first-child {
            padding-left: 0;
        }

        .rwd-table th:last-child,
        .rwd-table td:last-child {
            padding-right: 0;
        }

        .rwd-table th,
        .rwd-table td {
            padding: 8px !important;
            border: 1px solid #ddd;
        }
    }

    .custom-input-search input[type=date].form-control {
        border: 1px solid #ddd;
        border-radius: 30px;
        padding: 18px 10px;
        line-height: 26px;
    }

    .custom-input-search .btn {
        padding: 10px 20px;
        border-radius: 30px;
        background: linear-gradient(45deg, #3d4b66, #59abff);
        border: none;
        line-height: normal;
        font-size: 14px;
        font-weight: 500;
    }

    .custom-input-search .btn.reset {
        background: linear-gradient(90deg, #ff8b00, #f50000);
    }

    .custom-input-search .btn-primary:focus,
    .btn-primary.focus {
        box-shadow: none
    }

    .justify-content-center {
        justify-content: center
    }
</style>
<main>
    <div class="container-fluid mt-5">

       <div class="main" >
            <div class="row">
                @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','76']])->first())
                <div class="col-xl-6 col-md-6 col-sm-12">
                    <div class="card attendance   mb-4 color1"

                        style="background-color: #66ccff1c;height: 225px; border: 1px solid #59abff;">
                    <h5 class="card-title"><b>Operators</b> <img
                        src="{{asset('branch/images/operator.png')}}" alt=""></h5>
                        <p class=""><span>Operators ID: </span><span> {{!empty($operatorData)?$operatorData['Operator_Code']:''}}</span>  </p>
                        <p class=""><span>Operator Name : </span><span>{{!empty($operatorData)?$operatorData['Operator_Name']:''}}</span></p>
                        <p class=""><span>Station Code : </span><span>{{!empty($operatorData)?$operatorData['Station_Code']:''}}</span></p>
                        <p class=""><span>REG Code : </span><span>{{!empty($operatorData)?$operatorData['Registrar_Code']:''}}</span></p>
                        <p class=""><span>EA Code : </span><span>{{!empty($operatorData)?$operatorData['EA_Code']:''}}</span></p>
                        </div>
                </div>
                @endif
                @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','77']])->first())
                <div class="col-xl-6 col-md-6 col-sm-12">
                    <div class="card attendance text-dark  mb-4 color1" style="background-color: #cdac1812; height: 225px; border: 1px solid #cdac18;">
                    <h5 class="card-title"><b>Branch Details</b> <img
                        src="{{asset('branch/images/operator.png')}}" alt=""></h5>
                        <p><span>Branch Name :  </span><span>{{$branchData->branch_name}}</span></p>
                        {{-- <p><span>Attendance : </span><span>Days()</span></p> --}}
                        <p><span>Last Login : </span><span>{{date('d-M-Y h:i A', strtotime(Session::get('operatorsession')->last_login))}}</span></p>
                        <p><span>Last MIS Update : </span><span>{{date('d-M-Y', strtotime($lastMis->c_date))}}-{{$formattedTime}}</span></p>
                        {{-- <p><span>Enrolment Seqquence Break : </span><span>YES/NO</span></p> --}}
                    </div>
                </div>
                @endif
            </div>


            <div class="row " >



                <div class="col-lg-8" id="dashboardDataAjax">
                    <div class="row">
                        @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','75']])->first())

                        <div class="col-xl-6 col-md-6">
                            <div class="card attendance text-dark  mb-4 color1"
                                 style="background-color: #00ff662b; height: 209px; border: 1px solid #138942;">
                                <h5 class="card-title"><b>Total Enrolments Summary</b> </h5>
                                <div class="card-value">
                                    <p class=""><span> Total Enrolments :</span> <span>{{$Total_enrollments[0]->number}}</span> </p>
                                    <p class=""><span> New Enrolments :</span> <span>{{$new_enrollments[0]->number}}</span> </p>
                                    <p class=""><span> Mandatory Biometric Update :</span> <span>{{$mandatory_bio_biometric_update[0]->number}}</span> </p>
                                    <p class=""><span> Demographic Update :</span> <span>{{$total_demographic_update[0]->number}}</span> </p>
                                    <p class=""><span> Biometric Update :</span> <span>{{$biometric_update[0]->number}}</span> </p>
                                </div>

                            </div>

                        </div>
                        @endif
                        @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','74']])->first())

                        <div class="col-xl-6 col-md-6">
                            <div class="card attendance  text-dark  mb-4 color1"
                             style="background-color: #66ccff1c; height: 209px;  border: 1px solid #59abff;">

                                <h5 class="card-title"><b>Total Payment Summary</b> </h5>
                                <p><span>Total Amount Collected :</span> <span> {{$Total_enrollments[0]->Total_amount_charged}}</span></p>
                                <p><span>Demographic Update Amount :
                                        </span> <span>{{$total_demographic_update[0]->Total_amount_charged}}</span></p>
                                <p><span>Biometric Update Amount: </span> <span>{{$biometric_update[0]->Total_amount_charged}}</span></p>
                                <p><span>Payment Deposited : </span> <span>{{$PaymentDeposited}}</span></p>
                                <p><span>Payment Pending : </span> <span>{{$PaymentPending}}</span></p>
                            </div>
                        </div>
                        @endif
                    </div>

                </div>


                @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','73']])->first())

                 <div class="col-lg-4">
                            <div class="row">
                                <div class="col-lg-6 col-sm-12">
                                    <div class="mb-3">
                                        <label for="from_date" class="form-label">From Date</label>
                                        <input type="date" class="form-control" id="from_date"
                                            placeholder="Example input placeholder">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <div class="mb-3">
                                        <label for="to_date" class="form-label">To Date</label>
                                        <input type="date" class="form-control" id="to_date"
                                            placeholder="Example input placeholder">
                                    </div>
                                </div>
                                 <!--<div class="col-lg-4 col-sm-12">-->
                                    <div class="form-group" style="margin: 0.5rem auto;">
                                        <button type="button" onclick="filterData()" class="btn btn-primary"
                                            > Search</button>
                                        <button type="button" onclick="reset()" class="btn btn-primary reset"
                                           > Reset</button>
                                    </div>
                                <!--</div>-->

                            </div>
                            <div id="loadingbutton"></div>
                            <hr>
                        <!--</div>-->
                </div>
                @endif
            </div>
       </div>
    </div>
</main>

@endsection
@section('javascript')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
 window.onload = function() {

    $.ajax({
      type : "get",
      url  : "{{url('/operator/dashboard-report-operator')}}",
      dataType : 'json',
      success  : function(res) {
        if(res.status=='success'){
          $('#player-container').css('display','none');
          $('#dashboard_report').empty();
          $('#dashboard_report').append(res.data);
        }
      }
    });
}
</script>
<style>

.load{
  left: 50%;
  top:50%;
  transform: translate(-50%,-50%);
  position: absolute;
  height:100px;
  width:100px;
}

.square{
  height: 30px;
  width: 30px;
  border-radius: 50%;
  position: absolute;
  animation: spin 2s linear infinite;
}

.square:first-child{
  background-color: #4A00E0;
  animation-delay: -1.5s;
}
.square:nth-child(2){
  background-color: #FEAC5E;
  animation-delay: -1s;
}
.square:nth-child(3){
  background-color: #C779D0;
  animation-delay: -0.5s;
}
.square:last-child{
  background-color: #4BC0C8;
}

@keyframes spin{
  0%, 100%{
    transform: translate(0);
    opacity: 0.9;
  }

  25%{
    transform: translate(180%);
    opacity: 0;
  }

  50%{
    transform: translate(180%,180%);
    opacity: 0.9;
  }

  75%{
    transform: translate(0%,180%);
    opacity: 0;
  }
}


</style>
<script>
        function filterData(){
            // alert('hhh')
            var from_date = $('#from_date').val();
            var to_date   = $('#to_date').val();
            if(from_date!='' && to_date!=''){

              $.ajax({
                type : "post",
                url  : "{{url('/operator/dashboard-report-operator')}}",
                data : {
                  'from_date' : from_date,
                  "to_date"   : to_date,
                  "_token"    : "{{csrf_token()}}"
                },
                success  : function(res) {
                  if(res.status=='success'){

                    $('#dashboardDataAjax').empty();
                    $('#dashboardDataAjax').append(res.data);
                  }
                }
              });
            }else{
              alert('Please select date range.');
            }
        }
    </script>
@endsection
