@extends('operator.layouts.master')

@section('main-content')
<main>
    <div class="container-fluid">
        <h2 class="mt-5 mb-4">Enrollment Client</h2>

        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h6 class="card-title">Upload Html File MIS Date ({{isset($lastMisDate)?date('d-M-Y', strtotime($lastMisDate->c_date)).'-'.$formattedTime : 'Not upload'}})</h6>
                    </div>
                    <div class="card-body" id="demo">

                        <form action="{{ url('operator/enrollment-client-upload-excel') }}" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="excel_file">Html File</label>
                                        <input type="file" class="form-control" name="excel_file" id="fileInput" onchange="previewFile()" accept=".html, .htm">
                                      
                                        @error('excel_file')
                                        <p style="color: red">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-6"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div class="clear"></div>
                                        <input type="submit" value="Submit" class="btn btn-success float-right">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div id="preview" style="max-width: 100%; margin-top: 10px; display: none; overflow-x: scroll;"></div>
                                        <script>
                                            function previewFile() {
                                                $("body").addClass("sb-nav-fixed sb-sidenav-toggled");
                                                var preview = document.getElementById('preview');
                                                var fileInput = document.getElementById('fileInput');

                                                var file = fileInput.files[0];
                                                var reader = new FileReader();

                                                reader.onloadend = function () {
                                                    preview.innerHTML = '<p>' + reader.result + '</p>';
                                                    preview.style.display = 'block';
                                                };

                                                if (file) {
                                                    reader.readAsText(file); // Use readAsText for non-image files
                                                } else {
                                                    preview.innerHTML = '';
                                                    preview.style.display = 'none';
                                                }
                                            }
                                        </script>
                                    </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</main>
@endsection
