@extends('operator.layouts.master')
@section('main-content')
    <main>
        <div class="container-fluid">
            <h2 class="mt-5 mb-4">Fund Deposit Report</h2>
            <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">

                    </div>
                    <div class="responsive">
                    <form action="{{url('/operator/report/fund-deposit-report')}}" method="get">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>From Date</label>
                                <input type="date" name="from_date" id="from_date" class="form-control" value="{{Request::get('from_date')}}">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>To Date</label>
                                <input type="date" name="to_date" id="to_date" class="form-control" value="{{Request::get('to_date')}}">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <input type="submit" value="Filter" class="btn btn-primary" style="margin-top:25px;">
                        </div>
                    </form>
                    </div>
                </div>
                <br>
            </div>
            
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <!-- <h6 class="card-title"></h6> -->
                             @if (DB::table('model_has_permissions_operators')->where([['operator_code',Session::get('operatorsession')->Operator_Code ],['model_id','84']])->first())
               
                            <a onclick="excelDownload()" class="btn btn-primary"><i class="fa fa-download"></i> Fund Deposit Report</a>
                            @endif
                        </div>
                        <div class="card-body" id="demo">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th width="5%">S.No.</th>
                                            <th width="8%">Transaction Date</th>
                                            <th width="12%">Branch</th>
                                            <th width="20%">District</th>
                                            <th width="10%">Operator ID</th>
                                            <th width="10%">Operator Name</th>
                                            <th width="10%">Station Code	</th>
                                            <th>Transaction Amount</th>
                                            <th>Transaction Number	</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        @forelse ($enrollmentList as $key =>$val)
                                        <tr>
                                            <td>{{ $key+ $enrollmentList->firstItem() }}.</td>
                                            <td>{{date('d-m-Y',strtotime($val->date_of_transaction))}}</td>
                                            <td>{{$val->branch_name}}</td>
                                            <td>{{$val->district}}</td>
                                            <td>{{$val->Operator_Code}}</td>
                                            <td>{{$val->Operator_Name}}</td>
                                            <td>{{$val->Station_Code}}</td>
                                            <td>{{$val->amount_credited}}</td>
                                            <td>{{$val->transaction_no}}</td>
                                        </tr>
                                        @empty

                                        <tr>
                                            <td colspan="19">No Record Found !!</td>
                                        </tr>
                                            
                                        @endforelse
                                     
                                    </tbody>
                                </table>
                                {!!$enrollmentList->appends($_GET)->links()!!}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- end -->
                </div>
            </div>

        </div>
    </main>
    <!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<!-- Include Select2 CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css"  />

<!-- Include Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js" ></script>
<!-- Initialize Select2 -->
<script>
    jQuery(document).ready(function($) {
        $('#operator_code').select2();
    });
</script>
    <script>
        function excelDownload(){
            var from_date = $('#from_date').val();
            var to_date   = $('#to_date').val();
            window.location.href="{{url('/operator/get-excel-fund-deposit')}}?from_date="+from_date+"&to_date="+to_date;
             
        }
    </script>
@endsection
