<?php

use App\Http\Middleware\OperatorAuth;
// admin
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BranchOperatorController;
use App\Http\Controllers\admin\AdminAtuthController;
use App\Http\Controllers\admin\AdminBranchController;
use App\Http\Controllers\admin\AdminOperatorContoller;
use App\Http\Controllers\admin\AdminReportControllers;
use App\Http\Controllers\admin\ExportExcelControllers;
use App\Http\Controllers\admin\RegistraCodeController;
use App\Http\Controllers\branch\BranchAtuthController;
use App\Http\Controllers\admin\AdminDashboardController;
use App\Http\Controllers\AdminRolePermissionsController;
use App\Http\Controllers\admin\AdminMICReportControllers;
use App\Http\Controllers\admin\AdminBankUploadControllers;
use App\Http\Controllers\admin\AdminEnrollmentControllers;
use App\Http\Controllers\branch\BranchDashboardController;
use App\Http\Controllers\operator\OperatorAtuthController;
use App\Http\Controllers\operator\OperatorDashboardController;
use App\Http\Controllers\admin\SalaryController;

// for reports

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/***********************************************ADMIN*****************************************************/

// Route::get('/',function(){
// 	return view('front.index');
// });


// admin

Route::match(['get', 'post'], '/', [AdminAtuthController::class, 'Index']);
Route::match(['get', 'post'], '/admin-login', [AdminAtuthController::class, 'Index']);

Route::get('/admin/logout', [AdminAtuthController::class, 'logout']);
Route::group(['prefix' => 'admin', 'middleware' => 'AdminAuth'], function () {
    #salary
    Route::get('/salary-calculate', [SalaryController::class, 'salaryCalculation']);
    #filter AJAX
    Route::post('/get-district-ajax', [AdminReportControllers::class, 'District']);
    Route::post('/get-branch-ajax', [AdminReportControllers::class, 'Branch']);
    Route::post('/get-operator-ajax', [AdminReportControllers::class, 'Operator']);
    
    #excel report
    Route::get('/get-excel-report', [ExportExcelControllers::class, 'PSPLExcel']);
    Route::get('/get-excel-fund-deposit', [ExportExcelControllers::class, 'FundDeposit']);
    Route::get('/get-excel-branch-due', [ExportExcelControllers::class, 'branchDue']);
    Route::get('/get-excel-operator-list', [ExportExcelControllers::class, 'operatorListExcel']);
    Route::get('/get-excel-eid', [ExportExcelControllers::class, 'totalEID']);
    Route::get('/get-not-Operators-mis', [AdminDashboardController::class, 'NotOperatorsMis']);
    Route::get('/not-access', [AdminDashboardController::class, 'NotAccess'])->name('admin.not.access');

    #report
    Route::match(['get', 'post'], '/report', [AdminReportControllers::class, 'operatorReport']);
    Route::match(['get', 'post'], '/branch-report', [AdminReportControllers::class, 'branchReport']);

    #dashboard
    Route::get('/dashboard', [AdminDashboardController::class, 'Index']);
    Route::post('/dashboardAjax', [AdminDashboardController::class, 'dashboardAjax'])->name('dashboardAjax');
    Route::match(['get', 'post'], '/change-password', [AdminDashboardController::class, 'adminChangePassword']);
    Route::post('PsswordChange', [AdminDashboardController::class, 'PsswordChange']);
    Route::post('status-change', [AdminDashboardController::class, 'StatusChange'])->name('admin.StatusChange');
    // Attendance
    Route::group(['prefix' => 'attendance', 'as' => 'admin.attendance.'], function () {
        Route::get('/attendance-branches', [AdminDashboardController::class, 'attendanceBranch'])->name('post.branch');
        Route::get('/attendance-operators',[AdminDashboardController::class, 'attendanceOperator'])->name('post.operator');
    });
    //role_has_permissions
   Route::group(['prefix' => 'role-has-permissions', 'as' => 'admin.role_has_permissions.'], function () {
        Route::get('/list', [AdminRolePermissionsController::class, 'list'])->name('list');
        Route::get('/list-view/{id}', [AdminRolePermissionsController::class, 'listView'])->name('view');
        Route::get('/role', [AdminRolePermissionsController::class, 'role'])->name('role');
        Route::post('/role', [AdminRolePermissionsController::class, 'roleCreate']);
        Route::post('/role-update', [AdminRolePermissionsController::class, 'roleUpdate'])->name('role.update');
        Route::get('/add-user', [AdminRolePermissionsController::class, 'AddUser'])->name('user.role');
        Route::post('/add-user', [AdminRolePermissionsController::class, 'addUserStore']);
        Route::post('/add-user-update', [AdminRolePermissionsController::class, 'addUserStoreUpdate'])->name('user.role.update');
        Route::group(['prefix' => 'branch', 'as' => 'branch.'], function () {
            Route::get('/list-view/{id}', [AdminRolePermissionsController::class, 'BranchListView'])->name('view');
            Route::post('/role', [AdminRolePermissionsController::class, 'PermissionsCreateBranch'])->name('role');
        });
        Route::group(['prefix' => 'operator', 'as' => 'operator.'], function () {
            Route::get('/list-view/{id}', [AdminRolePermissionsController::class, 'operatorListView'])->name('view');
            Route::post('/role', [AdminRolePermissionsController::class, 'PermissionsCreateOperator'])->name('role');
        });
    });
    // branch

    Route::match(['get', 'post'], 'branch', [AdminBranchController::class, 'Index']);
    Route::get('view-branch', [AdminBranchController::class, 'ViewBranch']);
    Route::get('branch-update/{id}', [AdminBranchController::class, 'getUpdate']);


    Route::match(['get', 'post'], 'operator', [AdminOperatorContoller::class, 'Index']);
    Route::get('view-operator', [AdminOperatorContoller::class, 'ViewOperator']);
    Route::get('view-operator/{status}', [AdminOperatorContoller::class, 'ViewOperatorStatus'])->name('ViewOperatorStatus');
    Route::post('enrollment-client-upload-excel', [AdminOperatorContoller::class, 'uploadEnrollment']);

    Route::match(['get', 'post'], 'operator-upload-excel', [AdminOperatorContoller::class, 'ExcelUpload']);
    Route::match(['get', 'post'], 'enrollment-client', [AdminEnrollmentControllers::class, 'Index']);
    Route::match(['get', 'post'], 'enrollment-client-view', [AdminEnrollmentControllers::class, 'enrollmentList']);
        Route::get( 'enrollment-serial-missing-view', [AdminEnrollmentControllers::class, 'enrollmentListMissingSerial']);

    Route::match(['get', 'post'], 'upload-receive-amount', [AdminBankUploadControllers::class, 'bankUpload']);

    Route::match(['get', 'post'], 'receive-amount-list', [AdminBankUploadControllers::class, 'bankList']);

    #report
    Route::get('report/pspl-report', [AdminMICReportControllers::class, 'PSPL']);
    Route::get('report/shreetron-report', [AdminMICReportControllers::class, 'Streetron']);
    Route::get('report/fund-deposit-report', [AdminMICReportControllers::class, 'fundDeposit']);
    Route::get('report/branch-dues-report', [AdminMICReportControllers::class, 'operatorBranchDue']);
    Route::get('report/salary-report', [AdminMICReportControllers::class, 'salaryReport']);
    Route::get('report/total-eid-list', [AdminMICReportControllers::class, 'totalEid']);
    //Registrar code curd opratioin

    Route::group(['prefix' => 'registrar', 'as' => 'registrar.'], function () {
        Route::get('/', [RegistraCodeController::class, 'index'])->name('index');
        Route::get('/edit/{id}', [RegistraCodeController::class, 'edit'])->name('edit');
        Route::get('/delete/{id}', [RegistraCodeController::class, 'delete'])->name('delete');
        Route::post('/store', [RegistraCodeController::class, 'store'])->name('store');
        Route::post('/update', [RegistraCodeController::class, 'update'])->name('update');
        Route::post('/status-update', [RegistraCodeController::class, 'StatusUpdate'])->name('status.update');
    });
    Route::group(['prefix' => 'alert-message', 'as' => 'alertMessage.'], function () {
        Route::get('/', [RegistraCodeController::class, 'alertMessageIndex'])->name('index');
        Route::get('/edit/{id}', [RegistraCodeController::class, 'alertMessageEdit'])->name('edit');
        Route::get('/delete/{id}', [RegistraCodeController::class, 'delete'])->name('delete');
        Route::post('/store', [RegistraCodeController::class, 'alertMessageStore'])->name('store');
        Route::post('/update', [RegistraCodeController::class, 'update'])->name('update');
        Route::post('/status-update', [RegistraCodeController::class, 'StatusUpdate'])->name('status.update');
    });
    Route::get( '/operator-profile-update/{id}', [OperatorDashboardController::class, 'profileUpdate'])->name('edit.operator');
    Route::post( '/operator-profile-update', [OperatorDashboardController::class, 'profileUpdate']);
   
});



// Route::match(['get','post'],'/',[BranchAtuthController::class,'Index']);
Route::match(['get', 'post'], '/branch-login', [BranchAtuthController::class, 'Index']);

Route::group(['prefix' => 'branch', 'middleware' => 'BranchAuth'], function () {
    #ajax filter
    Route::post('/get-district-ajax', [AdminReportControllers::class, 'District']);
    Route::post('/get-branch-ajax', [AdminReportControllers::class, 'Branch']);
    Route::post('/get-operator-ajax', [AdminReportControllers::class, 'Operator']);
    #
    Route::get('/dashboard', [BranchDashboardController::class, 'Index']);
    Route::get('/not-access', [BranchDashboardController::class, 'NotAccess'])->name('branch.not.access');

    Route::post('/branch-dashboardAjax', [BranchDashboardController::class, 'dashboardAjax'])->name('branch.dashboardAjax');
    Route::get('/branch-report-ajax', [BranchDashboardController::class, 'branchAjaxReport']);
    Route::group(['prefix' => 'attendance', 'as' => 'branch.attendance.'], function () {
        Route::get('/', [BranchAtuthController::class, 'attendance'])->name('index');
        Route::post('/attendance-post-morning', [BranchAtuthController::class, 'attendancePost'])->name('post.morning');
        Route::post('/attendance-post-night', [BranchAtuthController::class, 'attendancePostNight'])->name('post.night');
        Route::get('/attendance-operators',[BranchAtuthController::class, 'attendanceOperator'])->name('post.operator');

    });

    Route::get('/logout', [BranchAtuthController::class, 'logout']);

    Route::match(['get', 'post'], '/change-password', [BranchDashboardController::class, 'branchChangePassword']);
    Route::post('PsswordChange', [BranchDashboardController::class, 'PsswordChange']);
    Route::match(['get', 'post'], 'receive-amount-list', [AdminBankUploadControllers::class, 'bankList']);
    Route::match(['get', 'post'], 'operator', [AdminOperatorContoller::class, 'Index']);
    Route::get('view-operator', [AdminOperatorContoller::class, 'ViewOperator']);
    Route::post('status-change', [AdminDashboardController::class, 'StatusChange'])->name('branch.StatusChange');

    Route::post('enrollment-client-upload-excel', [AdminOperatorContoller::class, 'uploadEnrollment']);
    Route::get('report/fund-deposit-report', [AdminMICReportControllers::class, 'fundDeposit']);
    Route::get('/get-excel-fund-deposit', [ExportExcelControllers::class, 'FundDeposit']);
    Route::get('report/pspl-report', [AdminMICReportControllers::class, 'PSPL']);
    Route::get('/get-excel-report', [ExportExcelControllers::class, 'PSPLExcel']);
    Route::get('/get-excel-operator-list', [ExportExcelControllers::class, 'operatorListExcel']);
    Route::match(['get', 'post'], 'operator-upload-excel', [AdminOperatorContoller::class, 'ExcelUpload']);
    Route::match(['get', 'post'], 'enrollment-client', [AdminEnrollmentControllers::class, 'Index']);
    Route::match(['get', 'post'], 'enrollment-client-view', [AdminEnrollmentControllers::class, 'enrollmentList']);
    Route::get('/get-not-Operators-mis', [BranchDashboardController::class, 'NotOperatorsMis']);

});



// operator

Route::match(['get', 'post'], '/operator-login', [OperatorAtuthController::class, 'Index']);

Route::group(['prefix' => 'operator', 'middleware' => 'OperatorAuth'], function () {
    Route::get('/dashboard', [OperatorDashboardController::class, 'Index']);
    Route::get('/not-access', [OperatorDashboardController::class, 'NotAccess'])->name('operator.not.access');

    Route::group(['prefix' => 'attendance', 'as' => 'attendance.'], function () {
        Route::get('/', [OperatorDashboardController::class, 'attendance'])->name('index');
        Route::post('/attendance-post-morning', [OperatorDashboardController::class, 'attendancePost'])->name('post.morning');
        Route::post('/attendance-post-night', [OperatorDashboardController::class, 'attendancePostNight'])->name('post.night');
    });
    Route::match(['get', 'post'], '/dashboard-report-operator', [OperatorDashboardController::class, 'ajaxDashboard']);
    Route::post('/operator-dashboardAjax', [OperatorDashboardController::class, 'ajaxDashboard'])->name('operator.dashboardAjax');

    Route::get('/report', [OperatorDashboardController::class, 'operatorReport']);

    Route::match(['get', 'post'], '/operator-profile-update', [OperatorDashboardController::class, 'profileUpdate']);

    Route::get('/logout', [OperatorAtuthController::class, 'logout']);
    Route::match(['get', 'post'], '/change-password', [OperatorDashboardController::class, 'branchChangePassword']);
    Route::post('PsswordChange', [OperatorDashboardController::class, 'PsswordChange']);

    #MIC
    Route::match(['get', 'post'], 'operator', [AdminOperatorContoller::class, 'Index']);
    Route::get('view-operator', [AdminOperatorContoller::class, 'ViewOperator']);
    Route::post('enrollment-client-upload-excel', [AdminOperatorContoller::class, 'uploadEnrollment']);

    Route::match(['get', 'post'], 'operator-upload-excel', [AdminOperatorContoller::class, 'ExcelUpload']);
    Route::match(['get', 'post'], 'enrollment-client', [AdminEnrollmentControllers::class, 'Index']);
    Route::match(['get', 'post'], 'enrollment-client-view', [AdminEnrollmentControllers::class, 'enrollmentList']);

    Route::match(['get', 'post'], 'upload-receive-amount', [AdminBankUploadControllers::class, 'bankUpload']);
    Route::match(['get', 'post'], 'receive-amount-list', [AdminBankUploadControllers::class, 'bankList']);
    #report
    Route::get('report/pspl-report', [AdminMICReportControllers::class, 'PSPL']);
    Route::get('report/fund-deposit-report', [AdminMICReportControllers::class, 'fundDeposit']);
    Route::get('/get-excel-report', [ExportExcelControllers::class, 'PSPLExcel']);

    Route::get('/get-excel-fund-deposit', [ExportExcelControllers::class, 'FundDeposit']);
});
