<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
<meta name="description" content="" />
<meta name="author" content="" />
<title>Admin Panel</title>
<link rel="shortcut icon" type="image/x-icon" href="favicon.ico">
<link href="<?php echo e(url('admin')); ?>/css/styles.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/js/all.min.js" crossorigin="anonymous"></script>
</head>
<body class="loginbg">
   <div id="layoutAuthentication" class="logincontainer">
      <div id="layoutAuthentication_content">
         <main>
            <div class="container">
            <form action="<?php echo e(url('branch-login')); ?>" method="post">   
            <div class="row">
                <?php echo csrf_field(); ?>
                            <div class="col-lg-6 pt-5 pt-sm-5 mb-sm-5 offset-sm-3">
                                <div class="card border-0">
                                    <div class="card-header d-flex align-items-center justify-content-center"><img src="admin/images/logo.png" alt=""></div>
                                    <div class="card-body px-sm-5 pt-sm-8">
                                        <h5 class="text-center font-weight-bold">Branch Login</h5>
                                        <div class="frm">
                                            <select id="loginRole" class="form-control" style="margin-bottom: 10px;">
                                                <option value="Admin">Admin</option>
                                                <option value="Branch" selected>Branch</option>
                                                <option value="Operator">Operator</option>
                                            </select>
                                        </div>
                                        <div class="frm-box">
                                             <label><img src="<?php echo e(url('branch')); ?>/images/log-d.png"></label>
                                             <input type="text" name="branch_code" placeholder="Branch Code" value="<?php echo e(old('branch_code')); ?>">
                                             <div class="clear"></div>
                                        </div>
                                        <?php if(!empty($errors)): ?>
                                            <div style="color:red"><?php echo e($errors->first('branch_code')); ?></div>
                                        <?php endif; ?>
                                        <div class="frm-box">
                                             <label><img src="<?php echo e(url('branch')); ?>/images/log-b.png"></label>
                                             <input type="password" name="password" placeholder="Password">
                                             <div class="clear"></div>
                                        </div>     
                                        <?php if(!empty($errors)): ?>
                                                        <div style="color:red"><?php echo e($errors->first('password')); ?></div>
                                                    <?php endif; ?>
                                            <?php if(isset($data['error'])): ?>
                                               <div style="color:red"> <?php echo e($data['error']); ?> </div>
                                            <?php endif; ?>                                
                                        <div class="form-group d-flex align-items-center justify-content-center mt-4 mb-0">
                                            <input type="submit" class="btn btn-primary d-inline loginbtn px-5" value="Login">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </form>
                    </div>
                </main>
            </div>
            <div id="layoutAuthentication_footer">
                <footer class="py-2 mt-auto fotr loginftr">
                    <div class="container-fluid">
                        Copyright &copy; <script>document.write(new Date().getFullYear())</script> Sure Trade. All Rights Reserved.
                        <a href="https://www.akswebsoft.com/" title="AKS Websoft Consulting Pvt. Ltd." target="_blank"><img src="branch/images/aks2.png" alt="AKS Websoft Consulting Pvt. Ltd." class="powerd akslogo"></a>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.min.js" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="admin/js/scripts.js"></script>
        <script>
            $('#loginRole').change(function(){
                var role = $(this).val();
                if(role=='Admin'){
                    window.location.href ="<?php echo e(url('/')); ?>/admin-login";
                }else if(role=='Branch'){
                    window.location.href ="<?php echo e(url('/')); ?>/branch-login";
                }else if(role=='Operator'){
                    window.location.href ="<?php echo e(url('/')); ?>/operator-login";
                }
            });
        </script>
    </body>
</html><?php /**PATH /home/aks5g/public_html/aadhar.aks.5g.in/resources/views/branch/index.blade.php ENDPATH**/ ?>